/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.ArrayList;
import java.util.List;

import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.ListTableModel;

public class LabItemChargesDataModel extends ListTableModel {

	public LabItemChargesDataModel() {
		setColumnNames(new String[] { "name", "translatedName", "price", "urgentPrice", "activeDisplay", "groupId", "groupName" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		MenuItem menuItem = (MenuItem) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return menuItem.getName();

			case 1:
				return menuItem.getDisplayName();

			case 2:
				return menuItem.getPrice();

			case 3:
				return menuItem.getUrgentPrice();

			case 4:
				return menuItem.getVisible() ? "Y" : "N";

			case 5:
				return menuItem.getMenuGroupId();

			case 6:
				return menuItem.getMenuGroupName();
		}
		return null;
	}

	public void addMenuItemDataList(List<MenuItem> items) {
		if (items == null || items.isEmpty()) {
			return;
		}
		if (getRows() == null) {
			setRows(new ArrayList<>());
		}
		getRows().addAll(items);
	}

}
