package com.floreantpos.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.ext.LabWorkStatus;
import com.floreantpos.model.util.DateUtil;

public class ProcessedStatus {

	private Date processedKey;
	private String labTestId;
	private String labDoctorId;
	private List<ProcessedStatusResult> statusResults;

	public Date getProcessedKey() {
		return processedKey;
	}

	public void setProcessedKey(Date processedKey) {
		this.processedKey = processedKey;
	}

	public String getLabTestId() {
		return labTestId;
	}

	public void setLabTestId(String labTestId) {
		this.labTestId = labTestId;
	}

	public String getLabDoctorId() {
		return labDoctorId;
	}

	public void setLabDoctorId(String labDoctorId) {
		this.labDoctorId = labDoctorId;
	}

	public List<ProcessedStatusResult> getStatusResults() {
		return statusResults;
	}

	public void setStatusResults(List<ProcessedStatusResult> statusResults) {
		this.statusResults = statusResults;
	}

	@Override
	public String toString() {
		return DateUtil.formatDateWithTimeAndSec(getProcessedKey());
	}

	public static ProcessedStatus createSampleCollectedStatus(TicketItem ticketItem) {
		ProcessedStatus processedStatus = new ProcessedStatus();
		processedStatus.setLabDoctorId(ticketItem.getLabDoctorId());
		processedStatus.setLabTestId(ticketItem.getLabTestId());
		Date serverTimestamp = StoreDAO.getServerTimestamp();
		processedStatus.setProcessedKey(serverTimestamp);

		List<ProcessedStatusResult> results = new ArrayList<ProcessedStatusResult>();
		results.add(ProcessedStatusResult.createSampleCollectedStatusResult(ticketItem));
		processedStatus.setStatusResults(results);
		return processedStatus;
	}

	public static ProcessedStatus createProcessedStatus(TicketItem ticketItem, LabWorkStatus labWorkStatus) {
		ProcessedStatus processedStatus = new ProcessedStatus();

		List<ProcessedStatusResult> results = new ArrayList<ProcessedStatusResult>();
		results.add(ProcessedStatusResult.createProcessedStatusResult(ticketItem, labWorkStatus));
		processedStatus.setStatusResults(results);
		return processedStatus;
	}

	static class ProcessedStatusResult {
		private String status;
		private String processedTime;
		private String sampleCollectionDate;
		private String note;
		private String declinedReason;
		private List<TestItem> testItems;

		public ProcessedStatusResult() {
		}

		public String getStatus() {
			return status;
		}

		public void setStatus(String status) {
			this.status = status;
		}

		public String getProcessedTime() {
			return processedTime;
		}

		public void setProcessedTime(String processedTime) {
			this.processedTime = processedTime;
		}

		public String getSampleCollectionDate() {
			return sampleCollectionDate;
		}

		public void setSampleCollectionDate(String sampleCollectionDate) {
			this.sampleCollectionDate = sampleCollectionDate;
		}

		public List<TestItem> getTestItems() {
			return testItems;
		}

		public void setTestItems(List<TestItem> testItems) {
			this.testItems = testItems;
		}

		public String getNote() {
			return note;
		}

		public void setNote(String note) {
			this.note = note;
		}

		public String getDeclinedReason() {
			return declinedReason;
		}

		public void setDeclinedReason(String declinedReason) {
			this.declinedReason = declinedReason;
		}

		@Override
		public String toString() {
			return getProcessedTime();
		}

		public static ProcessedStatusResult createProcessedStatusResult(TicketItem ticketItem, LabWorkStatus labWorkStatus) {
			String formatDateWithTime = DateUtil.formatDateWithTime(StoreDAO.getServerTimestamp());
			ProcessedStatusResult processedStatusResult = new ProcessedStatusResult();
			processedStatusResult.setProcessedTime(formatDateWithTime);

			if (LabWorkStatus.RESULT_RECORDED.equals(labWorkStatus)) {
				List<TestItem> testItems = ticketItem.getTestItems();
				processedStatusResult.setTestItems(testItems);
			}
			else if (LabWorkStatus.APPROVED.equals(labWorkStatus)) {
				List<TestItem> testItems = ticketItem.getTestItems();
				processedStatusResult.setTestItems(testItems);
				processedStatusResult.setNote(ticketItem.getName());
			}
			else if (LabWorkStatus.DECLINED.equals(labWorkStatus)) {
				processedStatusResult.setDeclinedReason(ticketItem.getDeclinedReason());
			}

			processedStatusResult.setStatus(labWorkStatus.name());
			return processedStatusResult;
		}

		public static ProcessedStatusResult createSampleCollectedStatusResult(TicketItem ticketItem) {
			String formatDateWithTime = DateUtil.formatDateWithTime(StoreDAO.getServerTimestamp());

			ProcessedStatusResult processedStatusResult = new ProcessedStatusResult();
			processedStatusResult.setStatus(LabWorkStatus.SAMPLE_COLLECTED.name());
			processedStatusResult.setProcessedTime(formatDateWithTime);
			processedStatusResult.setSampleCollectionDate(DateUtil.formatDateWithTime(ticketItem.getSampleCollectionDate()));
			return processedStatusResult;
		}

	}

}
