package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the ACCESS_LOG table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="ACCESS_LOG"
 */

public abstract class BaseAccessLog  implements Comparable, Serializable {

	public static String REF = "AccessLog"; //$NON-NLS-1$
	public static String PROP_LICENSE_EXPIRED_DATE = "licenseExpiredDate"; //$NON-NLS-1$
	public static String PROP_STORE_ADDRESS = "storeAddress"; //$NON-NLS-1$
	public static String PROP_OUTLET_NAME = "outletName"; //$NON-NLS-1$
	public static String PROP_PRODUCT_NAME = "productName"; //$NON-NLS-1$
	public static String PROP_STORE_NAME = "storeName"; //$NON-NLS-1$
	public static String PROP_TERMINAL_KEY = "terminalKey"; //$NON-NLS-1$
	public static String PROP_PRODUCT_ID = "productId"; //$NON-NLS-1$
	public static String PROP_ORDER_ID = "orderId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_USER_EMAIL = "userEmail"; //$NON-NLS-1$
	public static String PROP_STORE_ID = "storeId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_EMAIL = "customerEmail"; //$NON-NLS-1$
	public static String PROP_MARK_TEST_STORE = "markTestStore"; //$NON-NLS-1$
	public static String PROP_ACCESS_LOG_DATE = "accessLogDate"; //$NON-NLS-1$
	public static String PROP_COUNTRY = "country"; //$NON-NLS-1$
	public static String PROP_DEMO_LICENSE = "demoLicense"; //$NON-NLS-1$
	public static String PROP_IP_ADDRESS = "ipAddress"; //$NON-NLS-1$
	public static String PROP_STORE_URL = "storeUrl"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseAccessLog () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseAccessLog (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.Boolean deleted;
				private java.util.Date accessLogDate;
				private java.lang.String productId;
				private java.lang.String productName;
				private java.lang.String customerEmail;
				private java.lang.String terminalKey;
				private java.lang.String storeName;
				private java.lang.String outletName;
				private java.util.Date licenseExpiredDate;
				private java.lang.String orderId;
				private java.lang.String storeAddress;
				private java.lang.String country;
				private java.lang.String ipAddress;
				private java.lang.Boolean demoLicense;
				private java.lang.String properties;
				private java.lang.Boolean markTestStore;
				private java.lang.String storeId;
				private java.lang.String storeUrl;
				private java.lang.String userEmail;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="assigned"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: ACCESS_LOG_DATE
	 */

	public java.util.Date getAccessLogDate () {
			return accessLogDate;
	}



	/**
	 * Set the value related to the column: ACCESS_LOG_DATE
	 * @param accessLogDate the ACCESS_LOG_DATE value
	 */
			public void setAccessLogDate (java.util.Date accessLogDate) {
			this.accessLogDate = accessLogDate;
	}



	/**
	 * Return the value associated with the column: PRODUCT_ID
	 */

	public java.lang.String getProductId () {
			return productId;
	}



	/**
	 * Set the value related to the column: PRODUCT_ID
	 * @param productId the PRODUCT_ID value
	 */
			public void setProductId (java.lang.String productId) {
			this.productId = productId;
	}



	/**
	 * Return the value associated with the column: PRODUCT_NAME
	 */

	public java.lang.String getProductName () {
			return productName;
	}



	/**
	 * Set the value related to the column: PRODUCT_NAME
	 * @param productName the PRODUCT_NAME value
	 */
			public void setProductName (java.lang.String productName) {
			this.productName = productName;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_EMAIL
	 */

	public java.lang.String getCustomerEmail () {
			return customerEmail;
	}



	/**
	 * Set the value related to the column: CUSTOMER_EMAIL
	 * @param customerEmail the CUSTOMER_EMAIL value
	 */
			public void setCustomerEmail (java.lang.String customerEmail) {
			this.customerEmail = customerEmail;
	}



	/**
	 * Return the value associated with the column: TERMINAL_KEY
	 */

	public java.lang.String getTerminalKey () {
			return terminalKey;
	}



	/**
	 * Set the value related to the column: TERMINAL_KEY
	 * @param terminalKey the TERMINAL_KEY value
	 */
			public void setTerminalKey (java.lang.String terminalKey) {
			this.terminalKey = terminalKey;
	}



	/**
	 * Return the value associated with the column: STORE_NAME
	 */

	public java.lang.String getStoreName () {
			return storeName;
	}



	/**
	 * Set the value related to the column: STORE_NAME
	 * @param storeName the STORE_NAME value
	 */
			public void setStoreName (java.lang.String storeName) {
			this.storeName = storeName;
	}



	/**
	 * Return the value associated with the column: OUTLET_NAME
	 */

	public java.lang.String getOutletName () {
			return outletName;
	}



	/**
	 * Set the value related to the column: OUTLET_NAME
	 * @param outletName the OUTLET_NAME value
	 */
			public void setOutletName (java.lang.String outletName) {
			this.outletName = outletName;
	}



	/**
	 * Return the value associated with the column: LICENSE_EXPIRED_DATE
	 */

	public java.util.Date getLicenseExpiredDate () {
			return licenseExpiredDate;
	}



	/**
	 * Set the value related to the column: LICENSE_EXPIRED_DATE
	 * @param licenseExpiredDate the LICENSE_EXPIRED_DATE value
	 */
			public void setLicenseExpiredDate (java.util.Date licenseExpiredDate) {
			this.licenseExpiredDate = licenseExpiredDate;
	}



	/**
	 * Return the value associated with the column: ORDER_ID
	 */

	public java.lang.String getOrderId () {
			return orderId;
	}



	/**
	 * Set the value related to the column: ORDER_ID
	 * @param orderId the ORDER_ID value
	 */
			public void setOrderId (java.lang.String orderId) {
			this.orderId = orderId;
	}



	/**
	 * Return the value associated with the column: STORE_ADDRESS
	 */

	public java.lang.String getStoreAddress () {
			return storeAddress;
	}



	/**
	 * Set the value related to the column: STORE_ADDRESS
	 * @param storeAddress the STORE_ADDRESS value
	 */
			public void setStoreAddress (java.lang.String storeAddress) {
			this.storeAddress = storeAddress;
	}



	/**
	 * Return the value associated with the column: COUNTRY
	 */

	public java.lang.String getCountry () {
			return country;
	}



	/**
	 * Set the value related to the column: COUNTRY
	 * @param country the COUNTRY value
	 */
			public void setCountry (java.lang.String country) {
			this.country = country;
	}



	/**
	 * Return the value associated with the column: IP_ADDRESS
	 */

	public java.lang.String getIpAddress () {
			return ipAddress;
	}



	/**
	 * Set the value related to the column: IP_ADDRESS
	 * @param ipAddress the IP_ADDRESS value
	 */
			public void setIpAddress (java.lang.String ipAddress) {
			this.ipAddress = ipAddress;
	}



	/**
	 * Return the value associated with the column: DEMO_LICENSE
	 */

	public java.lang.Boolean isDemoLicense () {
					return demoLicense == null ? Boolean.FALSE : demoLicense;
		}

	public java.lang.Boolean getDemoLicense () {
				return demoLicense == null ? Boolean.FALSE : demoLicense;
			}


	/**
	 * Set the value related to the column: DEMO_LICENSE
	 * @param demoLicense the DEMO_LICENSE value
	 */
			public void setDemoLicense (java.lang.Boolean demoLicense) {
			this.demoLicense = demoLicense;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: MARK_TEST_STORE
	 */

	public java.lang.Boolean isMarkTestStore () {
					return markTestStore == null ? Boolean.FALSE : markTestStore;
		}

	public java.lang.Boolean getMarkTestStore () {
				return markTestStore == null ? Boolean.FALSE : markTestStore;
			}


	/**
	 * Set the value related to the column: MARK_TEST_STORE
	 * @param markTestStore the MARK_TEST_STORE value
	 */
			public void setMarkTestStore (java.lang.Boolean markTestStore) {
			this.markTestStore = markTestStore;
	}



	/**
	 * Return the value associated with the column: STORE_ID
	 */

	public java.lang.String getStoreId () {
			return storeId;
	}



	/**
	 * Set the value related to the column: STORE_ID
	 * @param storeId the STORE_ID value
	 */
			public void setStoreId (java.lang.String storeId) {
			this.storeId = storeId;
	}



	/**
	 * Return the value associated with the column: STORE_URL
	 */

	public java.lang.String getStoreUrl () {
			return storeUrl;
	}



	/**
	 * Set the value related to the column: STORE_URL
	 * @param storeUrl the STORE_URL value
	 */
			public void setStoreUrl (java.lang.String storeUrl) {
			this.storeUrl = storeUrl;
	}



	/**
	 * Return the value associated with the column: USER_EMAIL
	 */

	public java.lang.String getUserEmail () {
			return userEmail;
	}



	/**
	 * Set the value related to the column: USER_EMAIL
	 * @param userEmail the USER_EMAIL value
	 */
			public void setUserEmail (java.lang.String userEmail) {
			this.userEmail = userEmail;
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.AccessLog)) return false;
		else {
			com.floreantpos.model.AccessLog accessLog = (com.floreantpos.model.AccessLog) obj;
			if (null == this.getId() || null == accessLog.getId()) return this == obj;
			else return (this.getId().equals(accessLog.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}