package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.util.DataProvider;

public class SharedCalcItemModel {
	private String id;
	private String name;
	private String menuItemId;
	private Number quantity = 0;
	private Number usedQuantity;
	private Number inventoryAdjustedQty = 0;
	private transient String performDateDisplay;
	private transient String performerName;

	public SharedCalcItemModel() {

	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getName() {
		if (StringUtils.isNotBlank(name)) {
			return name;
		}
		if (StringUtils.isNotBlank(menuItemId)) {
			MenuItem menuitem = (MenuItem) DataProvider.get().getObjectOf(MenuItem.class, menuItemId);
			if (menuitem != null) {
				name = menuitem.getName();
			}
		}
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getMenuItemId() {
		return menuItemId;
	}

	public void setMenuItemId(String menuItemId) {
		this.menuItemId = menuItemId;
	}

	public Number getQuantity() {
		return quantity;
	}

	public void setQuantity(Number quantity) {
		this.quantity = quantity;
	}

	public Number getUsedQuantity() {
		return usedQuantity;
	}

	public void setUsedQuantity(Number usedQuantity) {
		this.usedQuantity = usedQuantity;
	}

	public Number getInventoryAdjustedQty() {
		return inventoryAdjustedQty;
	}

	public void setInventoryAdjustedQty(Number inventoryAdjustQty) {
		this.inventoryAdjustedQty = inventoryAdjustQty;
	}

	public String getPerformDateDisplay() {
		return performDateDisplay;
	}

	public void setPerformDateDisplay(String performDateDisplay) {
		this.performDateDisplay = performDateDisplay;
	}

	public String getPerformerName() {
		return performerName;
	}

	public void setPerformerName(String performerName) {
		this.performerName = performerName;
	}

}