package com.floreantpos.report;

import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.castor.core.util.Base64Encoder;

import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.util.DataProvider;

public class StoreInfoReportUtil {

	public static void addStoreInfo(Outlet outlet, Map<String, Object> dataMap, String reportHeader) {
		Store store = DataProvider.get().getStore();
		String imageId = store.getImageId();
		if (StringUtils.isNotBlank(imageId)) {
			dataMap.put("storeLogo", new String(Base64Encoder.encode(DataProvider.get().getImageResource(imageId).getImageBytes()))); //$NON-NLS-1$
		}
		String storeName = store.getName();
		dataMap.put("storeName", storeName.toUpperCase()); //$NON-NLS-1$
		dataMap.put("storeAddress", StringUtils.isBlank(outlet.getAddressLine1()) ? "" : outlet.getAddressLine1()); //$NON-NLS-1$ //$NON-NLS-2$
		dataMap.put("storeAddress2", StringUtils.isBlank(outlet.getAddressLine2()) ? "" : outlet.getAddressLine2()); //$NON-NLS-1$ //$NON-NLS-2$
		dataMap.put("storeAddress3", StringUtils.isBlank(outlet.getAddressLine3()) ? "" : outlet.getAddressLine3()); //$NON-NLS-1$ //$NON-NLS-2$
		dataMap.put("storeContact", StringUtils.isBlank(outlet.getTelephone()) ? "" : "Phone: " + outlet.getTelephone()); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		dataMap.put("reportHeader", reportHeader); //$NON-NLS-1$
	}

}
