package com.floreantpos.extension.dejavoo;

import java.awt.Component;

import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.ui.views.payment.CardProcessor;

import net.xeoh.plugins.base.annotations.PluginImplementation;

@PluginImplementation
public class DejavooPaymentPlugin extends PaymentGatewayPlugin {

	//public static final String ID = String.valueOf("Deja-Pay".hashCode());
	public static final String ID = String.valueOf("Deja-Pay");

	private CardProcessor cardProcessor;

	@Override
	public String getId() {
		return ID;
	}

	@Override
	public boolean shouldShowCardInputProcessor() {
		return false;
	}

	@Override
	public CardProcessor getProcessor() {
		if (cardProcessor == null) {
			cardProcessor = new DejavooProcessor();
		}
		return cardProcessor;
	}

	@Override
	public String getProductName() {
		return "Dejavoo";
	}

	@Override
	public String getProductVersion() {
		return "2.2";
	}

	@Override
	public Integer getProductNumericVersion() {
		return null;
	}

	@Override
	public Component getParent() {
		return null;
	}

	@Override
	public String getUpdateServerURL() {
		return null;
	}

	@Override
	public String toString() {
		return getProductName();
	}
}
