package com.floreantpos.model;

import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BasePriceTableItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.InventoryUnitConvertionUtil;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "menuItem", "itemName" })
public class PriceTableItem extends BasePriceTableItem {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public PriceTableItem() {
	}

	/**
	 * Constructor for primary key
	 */
	public PriceTableItem(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/
	private MenuItem menuItem;
	private String itemName;
	private double regularPrice;

	@XmlTransient
	public MenuItem getMenuItem() {
		if (menuItem == null) {
			menuItem = MenuItemDAO.getInstance().get(getMenuItemId());
		}
		return menuItem;
	}

	public void setMenuItem(MenuItem menuItem) {
		this.menuItem = menuItem;
	}

	@XmlTransient
	public String getItemName() {
		return itemName;
	}

	public void setItemName(String itemName) {
		this.itemName = itemName;
	}

	public double getRegularPrice() {
		String unit = getUnit();
		MenuItem item = getMenuItem();
		Double variantPrice = item.getVariantPrice();
		if (StringUtils.isBlank(unit)) {
			return variantPrice;
		}
		IUnit inventoryUnit = DataProvider.get().getInventoryUnitById(unit);
		if (item.isAllowUnitSelection() || item.isAllowUnitWiseSelection()) {
			return item.getDestinationUnitPrice(item, inventoryUnit, variantPrice, item.getUnitQuantity(item.getUnit(), inventoryUnit));
		}
		return InventoryUnitConvertionUtil.calculatePrice(variantPrice, item.getUnit(), inventoryUnit, item);
	}

	public void setRegularPrice(double regularPrice) {
		this.regularPrice = regularPrice;
	}
}