package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum EntityType {
	PURCHASE;

	public static EntityType fromString(String s) {
		if (StringUtils.isBlank(s)) {
			return null;
		}

		try {
			return valueOf(s);
		} catch (Exception e) {
			return null;
		}
	}

	public static boolean match(String srcEntityTypeName, EntityType trgEntityType) {
		EntityType srcEntityType = fromString(srcEntityTypeName);
		return trgEntityType == srcEntityType;
	}
}
