/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;

import com.floreantpos.PosLog;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.PosTransaction;

public class UpdateDBTo464 {

	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo464(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void updateTransactionFields() {
		PosLog.info(getClass(), "Updating " + schemaName + " schema."); //$NON-NLS-1$ //$NON-NLS-2$

		int totalTransactions = rowCount();
		PosLog.info(UpdateDBTo464.class, "Found total transactions: " + totalTransactions); //$NON-NLS-1$

		int increment = 100;
		int count = 0;
		while (count < totalTransactions) {
			try (Session session = sessionFactory.openSession()) {
				Transaction transaction = session.beginTransaction();

				Pagination<PosTransaction> pagination = new Pagination<PosTransaction>(count, increment);
				pagination.setNumRows(totalTransactions);
				findPosTransactions(pagination, session);

				List<PosTransaction> posTransactions = pagination.getDataList();
				for (PosTransaction posTransaction : posTransactions) {
					posTransaction.setTransactionReason(posTransaction.getTransactionReason());
				}
				transaction.commit();

				count += increment;
			}
		}

		PosLog.info(getClass(), schemaName + " update completed successfully"); //$NON-NLS-1$
	}

	private void findPosTransactions(Pagination<PosTransaction> pagination, Session session) {
		Criteria criteria = createTransactionsCriteria(session);
		criteria.addOrder(Order.asc(PosTransaction.PROP_TRANSACTION_TIME));
		criteria.setFirstResult(pagination.getCurrentRowIndex());
		criteria.setMaxResults(pagination.getPageSize());

		PosLog.info(getClass(),
				String.format("Searching from: %s to %s", pagination.getCurrentRowIndex(), (pagination.getCurrentRowIndex() + pagination.getPageSize()))); //$NON-NLS-1$

		pagination.setRows(criteria.list());

	}

	public int rowCount() {
		try (Session session = sessionFactory.openSession()) {
			Criteria criteria = createTransactionsCriteria(session);
			criteria.setProjection(Projections.rowCount());
			return ((Long) criteria.uniqueResult()).intValue();
		}
	}

	private Criteria createTransactionsCriteria(Session session) {
		Criteria criteria = session.createCriteria(PosTransaction.class);
		return criteria;
	}

}