package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.NurseVisit;
import com.floreantpos.model.PatientBookingStatus;
import com.floreantpos.swing.PaginatedListModel;

public class NurseVisitDAO extends BaseNurseVisitDAO {

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		Serializable save = super.save(obj, s);
		performPostSaveOperations((NurseVisit) obj, s);
		return save;
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
		performPostSaveOperations((NurseVisit) obj, s);
	}

	@Override
	protected void delete(Object obj, Session s) {
		NurseVisit nurseVisit = (NurseVisit) obj;
		nurseVisit.setDeleted(true);
		update(nurseVisit, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
		performPostSaveOperations((NurseVisit) obj, s);
	}

	public void performPostSaveOperations(NurseVisit nurseVisit, Session session) {
		PatientHistoryDAO.getInstance().saveNurseVisitHistory(nurseVisit, session);
	}

	public void loadNurseVisit(PaginatedListModel<NurseVisit> dataModel, String patientId, String roomId, String bedId, String nurseId, String outletId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(NurseVisit.class);
			addDeletedFilter(criteria);
			if (StringUtils.isNotBlank(outletId)) {
				criteria.add(Restrictions.eq(NurseVisit.PROP_OUTLET_ID, outletId));
			}
			if (StringUtils.isNotBlank(patientId)) {
				criteria.add(Restrictions.eq(NurseVisit.PROP_PATIENT_ID, patientId));
			}
			if (StringUtils.isNotBlank(nurseId)) {
				criteria.add(Restrictions.eq(NurseVisit.PROP_NURSE_ID, nurseId));
			}

			DoctorVisitDAO.createRoomAndBedCriteria(roomId, bedId, criteria, NurseVisit.PROP_ADMISSION_ID, PatientBookingStatus.ACTIVE);

			dataModel.setNumRows(rowCount(criteria));

			criteria.addOrder(Order.desc(NurseVisit.PROP_CREATED_DATE));
			criteria.setFirstResult(dataModel.getCurrentRowIndex());
			criteria.setMaxResults(dataModel.getPageSize());
			dataModel.setData(criteria.list());
		}

	}

	public NurseVisit getLastNurseVisit(String bookingId) {
		if (StringUtils.isBlank(bookingId)) {
			return null;
		}
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(NurseVisit.class);
			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(NurseVisit.PROP_ADMISSION_ID, bookingId));
			criteria.addOrder(Order.desc(NurseVisit.PROP_CREATED_DATE));
			criteria.setMaxResults(1);
			return (NurseVisit) criteria.uniqueResult();
		}
	}

	public List<NurseVisit> getLatestNurseVisits(String bookingId, int maxResult) {
		if (StringUtils.isBlank(bookingId)) {
			return null;
		}
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(NurseVisit.class);
			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(NurseVisit.PROP_ADMISSION_ID, bookingId));
			criteria.setMaxResults(maxResult);
			criteria.addOrder(Order.desc(NurseVisit.PROP_CREATED_DATE));
			return criteria.list();
		}
	}

}