package com.floreantpos.model.util;

import org.apache.commons.lang.StringUtils;

public enum ReferralCommissionType {
	//@formatter:off
		EMPTY(""), //$NON-NLS-1$
		CATEGORY("Category"),
		GROUP("Group"),
		STANDARD("Standard"),
		PERCENTAGE("Percentage"),
		FIXEDAMOUNT("Fixed amount"),
		GREATER_THAN_SALES_PRICE("Mark up on B2B price $b2bPrice") 
		;
		//@formatter:on

	String displayString;
	String displayName;

	private ReferralCommissionType(String display) {
		this.displayString = display;
	}

	@Override
	public String toString() {
		if (!"Mark up on B2B price $b2bPrice".equals(displayString)) {
			return displayString;
		}
		return displayName;
	}

	public String getDisplayString() {
		return displayString;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public static ReferralCommissionType fromName(String name) {
		return fromName(name, ReferralCommissionType.PERCENTAGE);
	}

	public static ReferralCommissionType fromName(String name, ReferralCommissionType defaultReferralCommissionType) {

		if (StringUtils.isEmpty(name)) {
			return defaultReferralCommissionType;
		}

		ReferralCommissionType[] values = values();
		for (ReferralCommissionType chargeType : values) {
			if (name.equals(chargeType.name())) {
				return chargeType;
			}
		}

		return defaultReferralCommissionType;
	}
}
