package com.floreantpos.report.model;

import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;

public class PaymentReceivedReportModel2 extends ListTableModel {

	public PaymentReceivedReportModel2() {
		super(new String[] { "user", "transTime", "transNo", "ticket", "transType", "total", "memberName", "orderDate", "referralType", "referralBy", //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$//$NON-NLS-6$//$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$
				"referralId" }); //$NON-NLS-1$

	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		PaymentReceivedReportData data = (PaymentReceivedReportData) rows.get(rowIndex);
		switch (columnIndex) {
			case 0:
				return data.getUserDisplay();

			case 1:
				return data.getTransactionTimeDisplay();

			case 2:
				return data.getId();

			case 3:
				return data.getTicketId();

			case 4:
				return data.getPaymentTypeStringDisplay();

			case 5:
				return NumberUtil.round(data.getAmount());

			case 6:
				return ""; //$NON-NLS-1$

			case 7:
				return data.getOrderDateDisplay();

			case 8:
				return data.getReferralType();

			case 9:
				return data.getReferralBy();

			case 10:
				return data.getReferralId();
		}
		return null;
	}

}