/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.Messages;
import com.floreantpos.model.AdvanceRefundTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.swing.ListTableModel;

public class SalesDetailedReport {
	private Date fromDate;
	private Date toDate;
	private Date reportTime;

	int giftCertReturnCount;
	double giftCertReturnAmount;
	int giftCertChangeCount;
	double giftCertChangeAmount;

	int tipsCount;
	double chargedTips;
	double tipsPaid;
	double tipsDifferential;
	double totalSale;

	//private List<DrawerPullData> drawerPullDatas = new ArrayList<DrawerPullData>();
	private Map<String, CreditCardData> creditCardDatas = new HashMap<String, CreditCardData>();
	private Map<String, OtherPaymentData> otherPaymentDatas = new HashMap<String, OtherPaymentData>();
	private Map<String, RefundPaymentData> refundPaymentDatas = new HashMap<String, RefundPaymentData>();

	public void addCreditCardData(CreditCardTransaction t) {
		CreditCardData data = creditCardDatas.get(t.getCardType());
		if (data == null) {
			data = new CreditCardData();
			data.setCardName(t.getCardType());
			creditCardDatas.put(t.getCardType(), data);
		}
		data.setSalesCount(data.getSalesCount() + 1);
		data.setSalesAmount(data.getSalesAmount() + t.getAmount());
		data.setNetSalesAmount(data.getNetSalesAmount() + t.getAmount());
		//data.setNetTipsAmount(data.getNetTipsAmount() + t.getGratuityAmount());
	}

	public void addCreditCardData(DebitCardTransaction t) {
		CreditCardData data = creditCardDatas.get(t.getCardType());
		if (data == null) {
			data = new CreditCardData();
			data.setCardName(t.getCardType());
			creditCardDatas.put(t.getCardType(), data);
		}
		data.setSalesCount(data.getSalesCount() + 1);
		data.setSalesAmount(data.getSalesAmount() + t.getAmount());
		data.setNetSalesAmount(data.getNetSalesAmount() + t.getAmount());
		//		data.setNetTipsAmount(data.getNetTipsAmount() + t.getGratuityAmount());
	}

	public void addPaymentData(PosTransaction t) {
		PaymentType paymentType = t.getPaymentType();
		String cardType = t.getCardType();
		if (t instanceof RefundTransaction || t instanceof AdvanceRefundTransaction) {
			if (paymentType == PaymentType.CREDIT_CARD || paymentType == PaymentType.DEBIT_CARD) {
				RefundPaymentData data = refundPaymentDatas.get(cardType);
				if (data == null) {
					data = new RefundPaymentData();
					data.setPaymentName(cardType.replaceAll("_", " ")); //$NON-NLS-1$ //$NON-NLS-2$
					refundPaymentDatas.put(cardType, data);
				}
				data.setRefundCount(data.getRefundCount() + 1);
				data.setRefundAmount(data.getRefundAmount() + (t.getAmount() - t.getTipsAmount()));
			}
			else if (paymentType == PaymentType.CUSTOM_PAYMENT) {
				String customPaymentName = StringUtils.isBlank(t.getCustomPaymentName()) ? paymentType.getDisplayString() : t.getCustomPaymentName();
				RefundPaymentData data = refundPaymentDatas.get(customPaymentName);
				if (data == null) {
					data = new RefundPaymentData();
					data.setPaymentName(customPaymentName);
					refundPaymentDatas.put(customPaymentName, data);
				}
				data.setRefundCount(data.getRefundCount() + 1);
				data.setRefundAmount(data.getRefundAmount() + (t.getAmount() - t.getTipsAmount()));
			}
			else {
				RefundPaymentData data = refundPaymentDatas.get(t.getPaymentTypeString());
				if (data == null) {
					data = new RefundPaymentData();
					data.setPaymentName(t.getPaymentType().getDisplayString());
					refundPaymentDatas.put(t.getPaymentTypeString(), data);
				}
				data.setRefundCount(data.getRefundCount() + 1);
				data.setRefundAmount(data.getRefundAmount() + (t.getAmount() - t.getTipsAmount()));
			}
			totalSale -= t.getAmount() - t.getTipsAmount();
		}
		else if (paymentType == PaymentType.CUSTOM_PAYMENT) {
			if (t.isVoided()) {
				return;
			}
			String customPaymentName = StringUtils.isBlank(t.getCustomPaymentName()) ? paymentType.getDisplayString() : t.getCustomPaymentName();
			OtherPaymentData data = otherPaymentDatas.get(customPaymentName);
			if (data == null) {
				data = new OtherPaymentData();
				data.setPaymentName(customPaymentName);
				otherPaymentDatas.put(customPaymentName, data);
			}
			data.setSalesCount(data.getSalesCount() + 1);

			Double amount = t.getAmount();
			data.setSalesAmount(data.getSalesAmount() + (amount - t.getTipsAmount()));
			data.setNetSalesAmount(data.getNetSalesAmount() + (amount - t.getTipsAmount()));
			data.setNetTipsAmount(data.getNetTipsAmount() + t.getTipsAmount());
			totalSale += amount - t.getTipsAmount();
		}
		else if (paymentType == PaymentType.CASH || paymentType == PaymentType.GIFT_CERTIFICATE || paymentType == PaymentType.MEMBER_ACCOUNT) {
			if (t.isVoided()) {
				return;
			}
			OtherPaymentData data = otherPaymentDatas.get(t.getPaymentTypeString());
			if (data == null) {
				data = new OtherPaymentData();
				data.setPaymentName(t.getPaymentType().getDisplayString());
				otherPaymentDatas.put(t.getPaymentTypeString(), data);
			}
			data.setSalesCount(data.getSalesCount() + 1);
			data.setSalesAmount(data.getSalesAmount() + (t.getAmount() - t.getTipsAmount()));
			data.setNetSalesAmount(data.getNetSalesAmount() + (t.getAmount() - t.getTipsAmount()));
			data.setNetTipsAmount(data.getNetTipsAmount() + t.getTipsAmount());
			totalSale += t.getAmount() - t.getTipsAmount();
		}
		else if (paymentType == PaymentType.CREDIT_CARD || paymentType == PaymentType.DEBIT_CARD) {
			if (t.isVoided()) {
				if (!t.hasProperty(PosTransaction.JSON_PROP_REFUNDED_AMOUNT)) {
					return;
				}
			}

			CreditCardData data = creditCardDatas.get(cardType);
			if (data == null) {
				data = new CreditCardData();
				data.setCardName(cardType != null ? cardType.replaceAll("_", " ") : Messages.getString("SalesDetailedReport.0")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				creditCardDatas.put(cardType, data);
			}
			data.setSalesCount(data.getSalesCount() + 1);
			data.setSalesAmount(data.getSalesAmount() + (t.getAmount() - t.getTipsAmount()));
			data.setNetSalesAmount(data.getNetSalesAmount() + (t.getAmount() - t.getTipsAmount()));
			data.setNetTipsAmount(data.getNetTipsAmount() + t.getTipsAmount());
			totalSale += t.getAmount() - t.getTipsAmount();
		}
	}

	//	public void addDrawerPullData(DrawerPullData data) {
	//		drawerPullDatas.add(data);
	//	}
	//
	//	public static class DrawerPullData {
	//		private String drawerPullId;
	//		private String terminalName;
	//		private String openTime;
	//		private int ticketCount;
	//		private double idealAmount;
	//		private double actualAmount;
	//		private double varinceAmount;
	//
	//		public double getActualAmount() {
	//			return actualAmount;
	//		}
	//
	//		public void setActualAmount(double actualAmount) {
	//			this.actualAmount = actualAmount;
	//		}
	//
	//		public String getDrawerPullId() {
	//			return drawerPullId;
	//		}
	//
	//		public void setDrawerPullId(String drawerPullId) {
	//			this.drawerPullId = drawerPullId;
	//		}
	//
	//		public String getTerminalName() {
	//			return terminalName;
	//		}
	//
	//		public void setTerminalName(String terminalName) {
	//			this.terminalName = terminalName;
	//		}
	//
	//		public String getOpenTime() {
	//			return openTime;
	//		}
	//
	//		public void setOpenTime(String openTime) {
	//			this.openTime = openTime;
	//		}
	//
	//		public double getIdealAmount() {
	//			return idealAmount;
	//		}
	//
	//		public void setIdealAmount(double idealAmount) {
	//			this.idealAmount = idealAmount;
	//		}
	//
	//		public int getTicketCount() {
	//			return ticketCount;
	//		}
	//
	//		public void setTicketCount(int ticketCount) {
	//			this.ticketCount = ticketCount;
	//		}
	//
	//		public double getVarinceAmount() {
	//			return varinceAmount;
	//		}
	//
	//		public void setVarinceAmount(double varinceAmount) {
	//			this.varinceAmount = varinceAmount;
	//		}
	//
	//	}

	public static class CreditCardData {
		String cardName;
		int salesCount;
		double salesAmount;
		int refundCount;
		double refundAmount;
		double netSalesAmount;
		double netTipsAmount;
		double totalAmount;

		public String getCardName() {
			return cardName;
		}

		public void setCardName(String cardName) {
			this.cardName = cardName;
		}

		public double getNetSalesAmount() {
			return netSalesAmount;
		}

		public void setNetSalesAmount(double netSalesAmount) {
			this.netSalesAmount = netSalesAmount;
		}

		public double getNetTipsAmount() {
			return netTipsAmount;
		}

		public void setNetTipsAmount(double netTipsAmount) {
			this.netTipsAmount = netTipsAmount;
		}

		public double getTotalAmount() {
			return totalAmount;
		}

		public void setTotalAmount(double percentage) {
			this.totalAmount = percentage;
		}

		public double getRefundAmount() {
			return refundAmount;
		}

		public void setRefundAmount(double returnAmount) {
			this.refundAmount = returnAmount;
		}

		public int getRefundCount() {
			return refundCount;
		}

		public void setRefundCount(int returnCount) {
			this.refundCount = returnCount;
		}

		public double getSalesAmount() {
			return salesAmount;
		}

		public void setSalesAmount(double salesAmount) {
			this.salesAmount = salesAmount;
		}

		public int getSalesCount() {
			return salesCount;
		}

		public void setSalesCount(int salesCount) {
			this.salesCount = salesCount;
		}

	}

	public static class OtherPaymentData {
		String paymentName;
		int salesCount;
		double salesAmount;
		int returnCount;
		double returnAmount;
		double netSalesAmount;
		double netTipsAmount;
		double totalAmount;

		public String getPaymentName() {
			return paymentName;
		}

		public void setPaymentName(String paymentName) {
			this.paymentName = paymentName;
		}

		public double getNetSalesAmount() {
			return netSalesAmount;
		}

		public void setNetSalesAmount(double netSalesAmount) {
			this.netSalesAmount = netSalesAmount;
		}

		public double getNetTipsAmount() {
			return netTipsAmount;
		}

		public void setNetTipsAmount(double netTipsAmount) {
			this.netTipsAmount = netTipsAmount;
		}

		public double getTotalAmount() {
			return totalAmount;
		}

		public void setTotalAmount(double percentage) {
			this.totalAmount = percentage;
		}

		public double getReturnAmount() {
			return returnAmount;
		}

		public void setReturnAmount(double returnAmount) {
			this.returnAmount = returnAmount;
		}

		public int getReturnCount() {
			return returnCount;
		}

		public void setReturnCount(int returnCount) {
			this.returnCount = returnCount;
		}

		public double getSalesAmount() {
			return salesAmount;
		}

		public void setSalesAmount(double salesAmount) {
			this.salesAmount = salesAmount;
		}

		public int getSalesCount() {
			return salesCount;
		}

		public void setSalesCount(int salesCount) {
			this.salesCount = salesCount;
		}
	}

	public static class RefundPaymentData {
		String paymentName;
		int refundCount;
		double refundAmount;

		public String getPaymentName() {
			return paymentName;
		}

		public void setPaymentName(String paymentName) {
			this.paymentName = paymentName;
		}

		public double getRefundAmount() {
			return refundAmount;
		}

		public void setRefundAmount(double returnAmount) {
			this.refundAmount = returnAmount;
		}

		public int getRefundCount() {
			return refundCount;
		}

		public void setRefundCount(int returnCount) {
			this.refundCount = returnCount;
		}

	}

	public Date getFromDate() {
		return fromDate;
	}

	public void setFromDate(Date fromDate) {
		this.fromDate = fromDate;
	}

	public Date getReportTime() {
		return reportTime;
	}

	public void setReportTime(Date reportTime) {
		this.reportTime = reportTime;
	}

	public Date getToDate() {
		return toDate;
	}

	public void setToDate(Date toDate) {
		this.toDate = toDate;
	}

	//	public DrawerPullDataTableModel getDrawerPullDataTableModel() {
	//		DrawerPullDataTableModel model = new DrawerPullDataTableModel();
	//		model.setRows(this.drawerPullDatas);
	//
	//		return model;
	//	}

	public CreditCardDataTableModel getCreditCardDataTableModel() {
		CreditCardDataTableModel model = new CreditCardDataTableModel();
		List<CreditCardData> list = new ArrayList<CreditCardData>(creditCardDatas.values());
		model.setRows(list);
		double grandTotalAmount = 0D;
		int totalCount = 0;
		for (CreditCardData creditCardData : list) {
			double totalAmount = (creditCardData.getNetSalesAmount() + creditCardData.getNetTipsAmount());
			creditCardData.setTotalAmount(totalAmount);
			grandTotalAmount += totalAmount;
			totalCount += creditCardData.getSalesCount();
		}
		model.setGrandTotal(grandTotalAmount);
		model.setTotalCount(totalCount);
		return model;
	}

	public OtherPaymentDataTableModel getOtherPaymentDataTableModel() {
		double grandTotal = 0D;
		int totalCount = 0;
		OtherPaymentDataTableModel model = new OtherPaymentDataTableModel();
		List<OtherPaymentData> list = new ArrayList<OtherPaymentData>(otherPaymentDatas.values());
		List<OtherPaymentData> otherPaymentDataList = new ArrayList<OtherPaymentData>();
		for (OtherPaymentData otherPaymentData : list) {
			double totalAmount = (otherPaymentData.getNetSalesAmount() + otherPaymentData.getNetTipsAmount());
			otherPaymentData.setTotalAmount(totalAmount);
			if (otherPaymentData.getPaymentName() != null && otherPaymentData.getPaymentName().equals(PaymentType.CASH.getDisplayString())) {
				otherPaymentDataList.add(0, otherPaymentData);
			}
			else {
				otherPaymentDataList.add(otherPaymentData);
			}
			grandTotal += totalAmount;
			totalCount += otherPaymentData.getSalesCount();
		}
		model.setGrandTotal(grandTotal);
		model.setTotalCount(totalCount);
		model.setRows(otherPaymentDataList);
		return model;
	}

	public RefundPaymentDataTableModel getRefundPaymentDataTableModel() {
		double grandTotal = 0D;
		int totalCount = 0;
		RefundPaymentDataTableModel model = new RefundPaymentDataTableModel();
		List<RefundPaymentData> list = new ArrayList<RefundPaymentData>(refundPaymentDatas.values());
		List<RefundPaymentData> refundPaymentDataList = new ArrayList<RefundPaymentData>();
		for (RefundPaymentData refundData : list) {
			if (refundData.getPaymentName() != null && refundData.getPaymentName().equals(PaymentType.CASH.getDisplayString())) {
				refundPaymentDataList.add(0, refundData);
			}
			else {
				refundPaymentDataList.add(refundData);
			}
			grandTotal += refundData.getRefundAmount();
			totalCount += refundData.getRefundCount();
		}
		model.setGrandTotal(grandTotal);
		model.setTotalCount(totalCount);
		model.setRows(refundPaymentDataList);
		return model;
	}

	//	public class DrawerPullDataTableModel extends ListTableModel {
	//		public DrawerPullDataTableModel() {
	//			setColumnNames(new String[] { "no", "count", "ideal", "actual", "variant", "terminalName", "openTime" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
	//		}
	//
	//		public Object getValueAt(int rowIndex, int columnIndex) {
	//			DrawerPullData data = (DrawerPullData) rows.get(rowIndex);
	//
	//			switch (columnIndex) {
	//				case 0:
	//					return com.floreantpos.POSConstants.DRAWER_PULL_ + data.drawerPullId;
	//
	//				case 1:
	//					return data.getTicketCount();
	//
	//				case 2:
	//					return data.idealAmount;
	//
	//				case 3:
	//					return data.actualAmount;
	//
	//				case 4:
	//					return data.getVarinceAmount();
	//
	//				case 5:
	//					return data.getTerminalName();
	//
	//				case 6:
	//					return data.getOpenTime();
	//			}
	//
	//			return null;
	//		}
	//
	//	}

	public class CreditCardDataTableModel extends ListTableModel<CreditCardData> {
		private double grandTotal;
		private int totalCount;

		public CreditCardDataTableModel() {
			setColumnNames(
					new String[] { "creditCard", "salesCount", "salesAmount", "returnCount", "returnAmount", "netAmount", "netTipsAmount", "percentage" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
		}

		@Override
		public Object getValueAt(int rowIndex, int columnIndex) {
			CreditCardData data = rows.get(rowIndex);

			switch (columnIndex) {
				case 0:
					return data.cardName;

				case 1:
					return data.salesCount;

				case 2:
					return data.salesAmount;

				case 3:
					return data.refundCount;

				case 4:
					return data.refundAmount;
				case 5:
					return data.netSalesAmount;
				case 6:
					return data.netTipsAmount;
				case 7:
					return data.totalAmount;
			}

			return null;
		}

		public int getTotalCount() {
			return totalCount;
		}

		public void setTotalCount(int totalCount) {
			this.totalCount = totalCount;
		}

		public double getGrandTotal() {
			return grandTotal;
		}

		public void setGrandTotal(double grandTotal) {
			this.grandTotal = grandTotal;
		}

	}

	public class OtherPaymentDataTableModel extends ListTableModel<OtherPaymentData> {
		private double grandTotal;
		private int totalCount;

		public OtherPaymentDataTableModel() {
			setColumnNames(
					new String[] { "paymentName", "salesCount", "salesAmount", "returnCount", "returnAmount", "netAmount", "netTipsAmount", "percentage" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
		}

		@Override
		public Object getValueAt(int rowIndex, int columnIndex) {
			OtherPaymentData data = rows.get(rowIndex);

			switch (columnIndex) {
				case 0:
					return data.paymentName;

				case 1:
					return data.salesCount;

				case 2:
					return data.salesAmount;

				case 3:
					return data.returnCount;

				case 4:
					return data.returnAmount;
				case 5:
					return data.netSalesAmount;
				case 6:
					return data.netTipsAmount;
				case 7:
					return data.totalAmount;
			}

			return null;
		}

		public double getGrandTotal() {
			return grandTotal;
		}

		public void setGrandTotal(double totalAmount) {
			this.grandTotal = totalAmount;
		}

		public int getTotalCount() {
			return totalCount;
		}

		public void setTotalCount(int totalCount) {
			this.totalCount = totalCount;
		}

	}

	public class RefundPaymentDataTableModel extends ListTableModel<RefundPaymentData> {
		private double grandTotal;
		private int totalCount;

		public RefundPaymentDataTableModel() {
			setColumnNames(new String[] { "paymentName", "returnCount", "returnAmount" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ 
		}

		@Override
		public Object getValueAt(int rowIndex, int columnIndex) {
			RefundPaymentData data = rows.get(rowIndex);

			switch (columnIndex) {
				case 0:
					return data.paymentName;

				case 1:
					return data.refundCount;

				case 2:
					return -data.refundAmount;

			}

			return null;
		}

		public double getGrandTotal() {
			return grandTotal;
		}

		public void setGrandTotal(double grandTotal) {
			this.grandTotal = grandTotal;
		}

		public int getTotalCount() {
			return totalCount;
		}

		public void setTotalCount(int totalCount) {
			this.totalCount = totalCount;
		}

	}

	public double getChargedTips() {
		return chargedTips;
	}

	public void setChargedTips(double chargedTips) {
		this.chargedTips = chargedTips;
	}

	public double getGiftCertChangeAmount() {
		return giftCertChangeAmount;
	}

	public void setGiftCertChangeAmount(double giftCertChangeAmount) {
		this.giftCertChangeAmount = giftCertChangeAmount;
	}

	public int getGiftCertChangeCount() {
		return giftCertChangeCount;
	}

	public void setGiftCertChangeCount(int giftCertChangeCount) {
		this.giftCertChangeCount = giftCertChangeCount;
	}

	public double getGiftCertReturnAmount() {
		return giftCertReturnAmount;
	}

	public void setGiftCertReturnAmount(double giftCertReturnAmount) {
		this.giftCertReturnAmount = giftCertReturnAmount;
	}

	public int getGiftCertReturnCount() {
		return giftCertReturnCount;
	}

	public void setGiftCertReturnCount(int giftCertReturnCount) {
		this.giftCertReturnCount = giftCertReturnCount;
	}

	public double getTipsDifferential() {
		return tipsDifferential;
	}

	public void setTipsDifferential(double tipsDifferential) {
		this.tipsDifferential = tipsDifferential;
	}

	public double getTipsPaid() {
		return tipsPaid;
	}

	public void setTipsPaid(double tipsPaid) {
		this.tipsPaid = tipsPaid;
	}

	public int getTipsCount() {
		return tipsCount;
	}

	public void setTipsCount(int tipsCount) {
		this.tipsCount = tipsCount;
	}
}
