package com.floreantpos.model.dao;

import java.io.Serializable;

import org.hibernate.Session;

import com.floreantpos.PosException;
import com.floreantpos.model.AllergyCategory;

public class AllergyCategoryDAO extends BaseAllergyCategoryDAO {

	public AllergyCategoryDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	protected void delete(Object obj, Session session) {
		AllergyCategory dosageForms = (AllergyCategory) obj;
		if (dosageForms == null) {
			throw new PosException("Allergy category not found");
		}

		dosageForms.setDeleted(Boolean.TRUE);
		saveOrUpdate(dosageForms, session);
	}
}