/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

import com.floreantpos.PosLog;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;

public class UpdateDBTo462 {

	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo462(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void update() {
		PosLog.info(getClass(), "Updating " + schemaName + " schema."); //$NON-NLS-1$ //$NON-NLS-2$

		Store store = StoreDAO.getRestaurant();
		String outletId = store.getDefaultOutletId();
		if (StringUtils.isBlank(outletId)) {
			return;
		}

		PosLog.info(getClass(), "Main outlet id is: " + outletId);

		updateOutletId("doctor_visit", outletId);
		updateOutletId("nurse_visit", outletId);
		updateOutletId("floor", outletId);
		updateOutletId("block", outletId);
		updateOutletId("bed", outletId);
		updateOutletId("bed_feature", outletId);
		updateOutletId("room", outletId);
		updateOutletId("room_feature", outletId);

	}

	public void updateOutletId(String tableName, String outletID) {
		try (Session session = sessionFactory.openSession()) {
			Transaction transaction = session.beginTransaction();

			String hqlString = "update " + schemaName + ".%s set outlet_id = '%s'";
			hqlString = String.format(hqlString, tableName, outletID);

			SQLQuery sqlQuery = session.createSQLQuery(hqlString); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

			PosLog.info(getClass(), "updated query: " + sqlQuery + ""); //$NON-NLS-1$ //$NON-NLS-2$
			int update = sqlQuery.executeUpdate();
			PosLog.info(getClass(), "updated " + update + " " + tableName); //$NON-NLS-1$ //$NON-NLS-2$
			transaction.commit();
		}

	}

}