package com.floreantpos.model;

import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseChemoCycle;
import com.floreantpos.model.dao.StoreDAO;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.orocube.medlogics.chemo.ChemoDate;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "propertiesContainer", "chemotherapy" })
@XmlRootElement
public class ChemoCycle extends BaseChemoCycle implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ChemoCycle() {
		setCreatedDate(StoreDAO.getServerTimestamp());
	}

	/**
	 * Constructor for primary key
	 */
	public ChemoCycle(java.lang.String id) {
		super(id);
		setCreatedDate(StoreDAO.getServerTimestamp());
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	@Override
	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	@Override
	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	@Override
	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	// Helper methods for ChemoDate objects (day1-day7)
	// These methods serialize/deserialize ChemoDate objects to/from JSON strings

	public ChemoDate getChemoDateForDay1() {
		String json = super.getDay1();
		if (StringUtils.isEmpty(json)) {
			return null;
		}
		return new Gson().fromJson(json, ChemoDate.class);
	}

	public void setChemoDateForDay1(ChemoDate chemoDate) {
		if (chemoDate == null) {
			super.setDay1(null);
		} else {
			super.setDay1(new Gson().toJson(chemoDate));
		}
	}

	public ChemoDate getChemoDateForDay2() {
		String json = super.getDay2();
		if (StringUtils.isEmpty(json)) {
			return null;
		}
		return new Gson().fromJson(json, ChemoDate.class);
	}

	public void setChemoDateForDay2(ChemoDate chemoDate) {
		if (chemoDate == null) {
			super.setDay2(null);
		} else {
			super.setDay2(new Gson().toJson(chemoDate));
		}
	}

	public ChemoDate getChemoDateForDay3() {
		String json = super.getDay3();
		if (StringUtils.isEmpty(json)) {
			return null;
		}
		return new Gson().fromJson(json, ChemoDate.class);
	}

	public void setChemoDateForDay3(ChemoDate chemoDate) {
		if (chemoDate == null) {
			super.setDay3(null);
		} else {
			super.setDay3(new Gson().toJson(chemoDate));
		}
	}

	public ChemoDate getChemoDateForDay4() {
		String json = super.getDay4();
		if (StringUtils.isEmpty(json)) {
			return null;
		}
		return new Gson().fromJson(json, ChemoDate.class);
	}

	public void setChemoDateForDay4(ChemoDate chemoDate) {
		if (chemoDate == null) {
			super.setDay4(null);
		} else {
			super.setDay4(new Gson().toJson(chemoDate));
		}
	}

	public ChemoDate getChemoDateForDay5() {
		String json = super.getDay5();
		if (StringUtils.isEmpty(json)) {
			return null;
		}
		return new Gson().fromJson(json, ChemoDate.class);
	}

	public void setChemoDateForDay5(ChemoDate chemoDate) {
		if (chemoDate == null) {
			super.setDay5(null);
		} else {
			super.setDay5(new Gson().toJson(chemoDate));
		}
	}

	public ChemoDate getChemoDateForDay6() {
		String json = super.getDay6();
		if (StringUtils.isEmpty(json)) {
			return null;
		}
		return new Gson().fromJson(json, ChemoDate.class);
	}

	public void setChemoDateForDay6(ChemoDate chemoDate) {
		if (chemoDate == null) {
			super.setDay6(null);
		} else {
			super.setDay6(new Gson().toJson(chemoDate));
		}
	}

	public ChemoDate getChemoDateForDay7() {
		String json = super.getDay7();
		if (StringUtils.isEmpty(json)) {
			return null;
		}
		return new Gson().fromJson(json, ChemoDate.class);
	}

	public void setChemoDateForDay7(ChemoDate chemoDate) {
		if (chemoDate == null) {
			super.setDay7(null);
		} else {
			super.setDay7(new Gson().toJson(chemoDate));
		}
	}

	// Additional helper methods
	public Date getStartDate() {
		String startDate = getProperty("startDate");
		if (StringUtils.isEmpty(startDate)) {
			return null;
		}
		return new Gson().fromJson(startDate, Date.class);
	}

	public void setStartDate(Date startDate) {
		if (startDate == null) {
			removeProperty("startDate");
		}
		else {
			addProperty("startDate", new Gson().toJson(startDate));
		}
	}

	public Date getEndDate() {
		String endDate = getProperty("endDate");
		if (StringUtils.isEmpty(endDate)) {
			return null;
		}
		return new Gson().fromJson(endDate, Date.class);
	}

	public void setEndDate(Date endDate) {
		if (endDate == null) {
			removeProperty("endDate");
		}
		else {
			addProperty("endDate", new Gson().toJson(endDate));
		}
	}

	public Date getNextCycleDate() {
		String nextCycleDate = getProperty("nextCycleDate");
		if (StringUtils.isEmpty(nextCycleDate)) {
			return null;
		}
		return new Gson().fromJson(nextCycleDate, Date.class);
	}

	public void setNextCycleDate(Date nextCycleDate) {
		if (nextCycleDate == null) {
			removeProperty("nextCycleDate");
		}
		else {
			addProperty("nextCycleDate", new Gson().toJson(nextCycleDate));
		}
	}

	public String getDelayReason() {
		return getProperty("delayReason", "");
	}

	public void setDelayReason(String delayReason) {
		if (StringUtils.isEmpty(delayReason)) {
			removeProperty("delayReason");
		}
		else {
			addProperty("delayReason", delayReason);
		}
	}

	@Override
	public String toString() {
		return "ChemoCycle[" + getId() + "] - Cycle " + getCycleNumber() + " - " + getStatus();
	}
}
