package com.floreantpos.model;

public enum InvoiceTemplateType {
	QUOTATION("Quotation");

	private final String displayName;

	InvoiceTemplateType(String displayName) {
		this.displayName = displayName;
	}

	public String getDisplayName() {
		return displayName;
	}

	@Override
	public String toString() {
		return displayName;
	}

	public static InvoiceTemplateType fromDisplayName(String displayName) {
		if (displayName == null) {
			return null;
		}
		InvoiceTemplateType[] types = values();
		for (InvoiceTemplateType type : types) {
			if (type.getDisplayName().equals(displayName)) {
				return type;
			}
		}
		return null;
	}

	public static InvoiceTemplateType fromName(String name) {
		if (name == null) {
			return null;
		}
		try {
			return InvoiceTemplateType.valueOf(name);
		} catch (IllegalArgumentException e) {
			return null;
		}
	}
}
