package com.floreantpos.model.base;

import java.io.Serializable;

/**
 * This is an object that contains data related to the CHEMO_CYCLE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="CHEMO_CYCLE"
 */
public abstract class BaseChemoCycle implements Comparable, Serializable {

	public static String REF = "ChemoCycle"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_CHEMOTHERAPY = "chemotherapy"; //$NON-NLS-1$
	public static String PROP_CYCLE_NUMBER = "cycleNumber"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_DAY_1 = "day1"; //$NON-NLS-1$
	public static String PROP_DAY_2 = "day2"; //$NON-NLS-1$
	public static String PROP_DAY_3 = "day3"; //$NON-NLS-1$
	public static String PROP_DAY_4 = "day4"; //$NON-NLS-1$
	public static String PROP_DAY_5 = "day5"; //$NON-NLS-1$
	public static String PROP_DAY_6 = "day6"; //$NON-NLS-1$
	public static String PROP_DAY_7 = "day7"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_PERFORMER_ID = "performerId"; //$NON-NLS-1$
	public static String PROP_PERFORMER_NAME = "performerName"; //$NON-NLS-1$

	// constructors
	public BaseChemoCycle() {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseChemoCycle(java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize() {}

	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
	private java.lang.Integer cycleNumber;
	private java.lang.String status;
	private java.lang.String day1;
	private java.lang.String day2;
	private java.lang.String day3;
	private java.lang.String day4;
	private java.lang.String day5;
	private java.lang.String day6;
	private java.lang.String day7;
	private java.lang.String outletId;
	private java.util.Date createdDate;
	private java.util.Date lastUpdateTime;
	private java.util.Date lastSyncTime;
	private java.lang.Boolean deleted;
	private java.lang.String properties;
	private java.lang.String performerId;
	private java.lang.String performerName;

	// many to one
	private com.floreantpos.model.Chemotherapy chemotherapy;

	// collections
	private java.util.List<com.floreantpos.model.ChemoProcessNote> processNotes;

	/**
	 * Return the unique identifier of this class
	 * @hibernate.id
	 *  generator-class="com.floreantpos.util.UUIdGenerator"
	 *  column="ID"
	 */
	public java.lang.String getId() {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId(java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}

	/**
	 * Return the value associated with the column: CHEMOTHERAPY_ID
	 */
	public com.floreantpos.model.Chemotherapy getChemotherapy() {
		return chemotherapy;
	}

	/**
	 * Set the value related to the column: CHEMOTHERAPY_ID
	 * @param chemotherapy the CHEMOTHERAPY_ID value
	 */
	public void setChemotherapy(com.floreantpos.model.Chemotherapy chemotherapy) {
		this.chemotherapy = chemotherapy;
	}

	/**
	 * Return the value associated with the column: CYCLE_NUMBER
	 */
	public java.lang.Integer getCycleNumber() {
		return cycleNumber;
	}

	/**
	 * Set the value related to the column: CYCLE_NUMBER
	 * @param cycleNumber the CYCLE_NUMBER value
	 */
	public void setCycleNumber(java.lang.Integer cycleNumber) {
		this.cycleNumber = cycleNumber;
	}

	/**
	 * Return the value associated with the column: STATUS
	 */
	public java.lang.String getStatus() {
		return status;
	}

	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
	public void setStatus(java.lang.String status) {
		this.status = status;
	}

	/**
	 * Return the value associated with the column: DAY_1
	 */
	public java.lang.String getDay1() {
		return day1;
	}

	/**
	 * Set the value related to the column: DAY_1
	 * @param day1 the DAY_1 value
	 */
	public void setDay1(java.lang.String day1) {
		this.day1 = day1;
	}

	/**
	 * Return the value associated with the column: DAY_2
	 */
	public java.lang.String getDay2() {
		return day2;
	}

	/**
	 * Set the value related to the column: DAY_2
	 * @param day2 the DAY_2 value
	 */
	public void setDay2(java.lang.String day2) {
		this.day2 = day2;
	}

	/**
	 * Return the value associated with the column: DAY_3
	 */
	public java.lang.String getDay3() {
		return day3;
	}

	/**
	 * Set the value related to the column: DAY_3
	 * @param day3 the DAY_3 value
	 */
	public void setDay3(java.lang.String day3) {
		this.day3 = day3;
	}

	/**
	 * Return the value associated with the column: DAY_4
	 */
	public java.lang.String getDay4() {
		return day4;
	}

	/**
	 * Set the value related to the column: DAY_4
	 * @param day4 the DAY_4 value
	 */
	public void setDay4(java.lang.String day4) {
		this.day4 = day4;
	}

	/**
	 * Return the value associated with the column: DAY_5
	 */
	public java.lang.String getDay5() {
		return day5;
	}

	/**
	 * Set the value related to the column: DAY_5
	 * @param day5 the DAY_5 value
	 */
	public void setDay5(java.lang.String day5) {
		this.day5 = day5;
	}

	/**
	 * Return the value associated with the column: DAY_6
	 */
	public java.lang.String getDay6() {
		return day6;
	}

	/**
	 * Set the value related to the column: DAY_6
	 * @param day6 the DAY_6 value
	 */
	public void setDay6(java.lang.String day6) {
		this.day6 = day6;
	}

	/**
	 * Return the value associated with the column: DAY_7
	 */
	public java.lang.String getDay7() {
		return day7;
	}

	/**
	 * Set the value related to the column: DAY_7
	 * @param day7 the DAY_7 value
	 */
	public void setDay7(java.lang.String day7) {
		this.day7 = day7;
	}

	/**
	 * Return the value associated with the column: OUTLET_ID
	 */
	public java.lang.String getOutletId() {
		return outletId;
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
	public void setOutletId(java.lang.String outletId) {
		this.outletId = outletId;
	}

	/**
	 * Return the value associated with the column: CREATED_DATE
	 */
	public java.util.Date getCreatedDate() {
		return createdDate;
	}

	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
	public void setCreatedDate(java.util.Date createdDate) {
		this.createdDate = createdDate;
	}

	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */
	public java.util.Date getLastUpdateTime() {
		return lastUpdateTime;
	}

	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
	public void setLastUpdateTime(java.util.Date lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */
	public java.util.Date getLastSyncTime() {
		return lastSyncTime;
	}

	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
	public void setLastSyncTime(java.util.Date lastSyncTime) {
		this.lastSyncTime = lastSyncTime;
	}

	/**
	 * Return the value associated with the column: DELETED
	 */
	public java.lang.Boolean isDeleted() {
		return deleted == null ? Boolean.valueOf(false) : deleted;
	}

	public java.lang.Boolean getDeleted() {
		return deleted == null ? Boolean.valueOf(false) : deleted;
	}

	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
	public void setDeleted(java.lang.Boolean deleted) {
		this.deleted = deleted;
	}

	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue() {
		return "false";
	}

	/**
	 * Return the value associated with the column: PROPERTIES
	 */
	public java.lang.String getProperties() {
		return properties;
	}

	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
	public void setProperties(java.lang.String properties) {
		this.properties = properties;
	}

	/**
	 * Return the value associated with the column: PERFORMER_ID
	 */
	public java.lang.String getPerformerId() {
		return performerId;
	}

	/**
	 * Set the value related to the column: PERFORMER_ID
	 * @param performerId the PERFORMER_ID value
	 */
	public void setPerformerId(java.lang.String performerId) {
		this.performerId = performerId;
	}

	/**
	 * Return the value associated with the column: PERFORMER_NAME
	 */
	public java.lang.String getPerformerName() {
		return performerName;
	}

	/**
	 * Set the value related to the column: PERFORMER_NAME
	 * @param performerName the PERFORMER_NAME value
	 */
	public void setPerformerName(java.lang.String performerName) {
		this.performerName = performerName;
	}

	/**
	 * Return the value associated with the column: processNotes
	 */
	public java.util.List<com.floreantpos.model.ChemoProcessNote> getProcessNotes() {
		return processNotes;
	}

	/**
	 * Set the value related to the column: processNotes
	 * @param processNotes the processNotes value
	 */
	public void setProcessNotes(java.util.List<com.floreantpos.model.ChemoProcessNote> processNotes) {
		this.processNotes = processNotes;
	}

	public void addToProcessNotes(com.floreantpos.model.ChemoProcessNote chemoProcessNote) {
		if (null == getProcessNotes()) setProcessNotes(new java.util.ArrayList<com.floreantpos.model.ChemoProcessNote>());
		getProcessNotes().add(chemoProcessNote);
	}

	public boolean equals(Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.ChemoCycle)) return false;
		else {
			com.floreantpos.model.ChemoCycle chemoCycle = (com.floreantpos.model.ChemoCycle) obj;
			if (null == this.getId() || null == chemoCycle.getId()) return this == obj;
			else return (this.getId().equals(chemoCycle.getId()));
		}
	}

	public int hashCode() {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo(Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString() {
		return super.toString();
	}
}
