package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the INVENTORY_TRANSACTION table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="INVENTORY_TRANSACTION"
 */

public abstract class BaseInventoryTransaction  implements Comparable, Serializable {

	public static String REF = "InventoryTransaction"; //$NON-NLS-1$
	public static String PROP_MRP_PRICE = "mrpPrice"; //$NON-NLS-1$
	public static String PROP_FROM_LOCATION_ID = "fromLocationId"; //$NON-NLS-1$
	public static String PROP_TO_LOCATION_ID = "toLocationId"; //$NON-NLS-1$
	public static String PROP_VENDOR_ID = "vendorId"; //$NON-NLS-1$
	public static String PROP_TO_OULTET_ID = "toOultetId"; //$NON-NLS-1$
	public static String PROP_UNIT = "unit"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_REASON = "reason"; //$NON-NLS-1$
	public static String PROP_REMARK = "remark"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_UNIT_TYPE = "unitType"; //$NON-NLS-1$
	public static String PROP_TRANSACTION_DATE = "transactionDate"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_BATCH_NUMBER = "batchNumber"; //$NON-NLS-1$
	public static String PROP_QUANTITY = "quantity"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM = "menuItem"; //$NON-NLS-1$
	public static String PROP_BASE_UNIT = "baseUnit"; //$NON-NLS-1$
	public static String PROP_UNIT_COST = "unitCost"; //$NON-NLS-1$
	public static String PROP_UNIT_PRICE = "unitPrice"; //$NON-NLS-1$
	public static String PROP_TYPE = "type"; //$NON-NLS-1$
	public static String PROP_TICKET_ID = "ticketId"; //$NON-NLS-1$
	public static String PROP_BASE_UNIT_QUANTITY = "baseUnitQuantity"; //$NON-NLS-1$
	public static String PROP_USER_ID = "userId"; //$NON-NLS-1$
	public static String PROP_TOTAL = "total"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_REFERENCE_NO = "referenceNo"; //$NON-NLS-1$


	// constructors
	public BaseInventoryTransaction () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseInventoryTransaction (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date transactionDate;
				private java.lang.String reason;
				private java.lang.Double quantity;
				private java.lang.String unit;
				private java.lang.String unitType;
				private java.lang.Double unitPrice;
				private java.lang.Double mrpPrice;
				private java.lang.Double unitCost;
				private java.lang.Double baseUnitQuantity;
				private java.lang.String baseUnit;
				private java.lang.String remark;
				private java.lang.Double total;
				private java.lang.String batchNumber;
				private java.lang.String ticketId;
				private java.lang.String referenceNo;
				private java.lang.String outletId;
				private java.lang.String fromLocationId;
				private java.lang.String toLocationId;
				private java.lang.String toOultetId;
				private java.lang.String vendorId;
				private java.lang.String userId;
				private java.lang.Integer type;
				private java.lang.String properties;
	
	// many to one
	private com.floreantpos.model.MenuItem menuItem;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: TRANSACTION_DATE
	 */

	public java.util.Date getTransactionDate () {
			return transactionDate;
	}



	/**
	 * Set the value related to the column: TRANSACTION_DATE
	 * @param transactionDate the TRANSACTION_DATE value
	 */
			public void setTransactionDate (java.util.Date transactionDate) {
			this.transactionDate = transactionDate;
	}



	/**
	 * Return the value associated with the column: INVENTORY_TYPE
	 */

	public java.lang.String getReason () {
			return reason;
	}



	/**
	 * Set the value related to the column: INVENTORY_TYPE
	 * @param reason the INVENTORY_TYPE value
	 */
			public void setReason (java.lang.String reason) {
			this.reason = reason;
	}



	/**
	 * Return the value associated with the column: QUANTITY
	 */

	public java.lang.Double getQuantity () {
						return quantity == null ? Double.valueOf(0) : quantity;
		}



	/**
	 * Set the value related to the column: QUANTITY
	 * @param quantity the QUANTITY value
	 */
			public void setQuantity (java.lang.Double quantity) {
			this.quantity = quantity;
	}



	/**
	 * Return the value associated with the column: UNIT
	 */

	public java.lang.String getUnit () {
			return unit;
	}



	/**
	 * Set the value related to the column: UNIT
	 * @param unit the UNIT value
	 */
			public void setUnit (java.lang.String unit) {
			this.unit = unit;
	}



	/**
	 * Return the value associated with the column: UNIT_TYPE
	 */

	public java.lang.String getUnitType () {
			return unitType;
	}



	/**
	 * Set the value related to the column: UNIT_TYPE
	 * @param unitType the UNIT_TYPE value
	 */
			public void setUnitType (java.lang.String unitType) {
			this.unitType = unitType;
	}



	/**
	 * Return the value associated with the column: UNIT_PRICE
	 */

	public java.lang.Double getUnitPrice () {
						return unitPrice == null ? Double.valueOf(0) : unitPrice;
		}



	/**
	 * Set the value related to the column: UNIT_PRICE
	 * @param unitPrice the UNIT_PRICE value
	 */
			public void setUnitPrice (java.lang.Double unitPrice) {
			this.unitPrice = unitPrice;
	}



	/**
	 * Return the value associated with the column: MRP_PRICE
	 */

	public java.lang.Double getMrpPrice () {
						return mrpPrice == null ? Double.valueOf(0) : mrpPrice;
		}



	/**
	 * Set the value related to the column: MRP_PRICE
	 * @param mrpPrice the MRP_PRICE value
	 */
			public void setMrpPrice (java.lang.Double mrpPrice) {
			this.mrpPrice = mrpPrice;
	}



	/**
	 * Return the value associated with the column: UNIT_COST
	 */

	public java.lang.Double getUnitCost () {
						return unitCost == null ? Double.valueOf(0) : unitCost;
		}



	/**
	 * Set the value related to the column: UNIT_COST
	 * @param unitCost the UNIT_COST value
	 */
			public void setUnitCost (java.lang.Double unitCost) {
			this.unitCost = unitCost;
	}



	/**
	 * Return the value associated with the column: BASE_UNIT_QUANTITY
	 */

	public java.lang.Double getBaseUnitQuantity () {
						return baseUnitQuantity == null ? Double.valueOf(0) : baseUnitQuantity;
		}



	/**
	 * Set the value related to the column: BASE_UNIT_QUANTITY
	 * @param baseUnitQuantity the BASE_UNIT_QUANTITY value
	 */
			public void setBaseUnitQuantity (java.lang.Double baseUnitQuantity) {
			this.baseUnitQuantity = baseUnitQuantity;
	}



	/**
	 * Return the value associated with the column: BASE_UNIT
	 */

	public java.lang.String getBaseUnit () {
			return baseUnit;
	}



	/**
	 * Set the value related to the column: BASE_UNIT
	 * @param baseUnit the BASE_UNIT value
	 */
			public void setBaseUnit (java.lang.String baseUnit) {
			this.baseUnit = baseUnit;
	}



	/**
	 * Return the value associated with the column: REMARK
	 */

	public java.lang.String getRemark () {
			return remark;
	}



	/**
	 * Set the value related to the column: REMARK
	 * @param remark the REMARK value
	 */
			public void setRemark (java.lang.String remark) {
			this.remark = remark;
	}



	/**
	 * Return the value associated with the column: TOTAL
	 */

	public java.lang.Double getTotal () {
						return total == null ? Double.valueOf(0) : total;
		}



	/**
	 * Set the value related to the column: TOTAL
	 * @param total the TOTAL value
	 */
			public void setTotal (java.lang.Double total) {
			this.total = total;
	}



	/**
	 * Return the value associated with the column: BATCH_NUMBER
	 */

	public java.lang.String getBatchNumber () {
			return batchNumber;
	}



	/**
	 * Set the value related to the column: BATCH_NUMBER
	 * @param batchNumber the BATCH_NUMBER value
	 */
			public void setBatchNumber (java.lang.String batchNumber) {
			this.batchNumber = batchNumber;
	}



	/**
	 * Return the value associated with the column: TICKET_ID_STR
	 */

	public java.lang.String getTicketId () {
			return ticketId;
	}



	/**
	 * Set the value related to the column: TICKET_ID_STR
	 * @param ticketId the TICKET_ID_STR value
	 */
			public void setTicketId (java.lang.String ticketId) {
			this.ticketId = ticketId;
	}



	/**
	 * Return the value associated with the column: REF_NO
	 */

	public java.lang.String getReferenceNo () {
			return referenceNo;
	}



	/**
	 * Set the value related to the column: REF_NO
	 * @param referenceNo the REF_NO value
	 */
			public void setReferenceNo (java.lang.String referenceNo) {
			this.referenceNo = referenceNo;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: FROM_INVENTORY_LOCATION
	 */

	public java.lang.String getFromLocationId () {
			return fromLocationId;
	}



	/**
	 * Set the value related to the column: FROM_INVENTORY_LOCATION
	 * @param fromLocationId the FROM_INVENTORY_LOCATION value
	 */
			public void setFromLocationId (java.lang.String fromLocationId) {
			this.fromLocationId = fromLocationId;
	}



	/**
	 * Return the value associated with the column: TO_INVENTORY_LOCATION
	 */

	public java.lang.String getToLocationId () {
			return toLocationId;
	}



	/**
	 * Set the value related to the column: TO_INVENTORY_LOCATION
	 * @param toLocationId the TO_INVENTORY_LOCATION value
	 */
			public void setToLocationId (java.lang.String toLocationId) {
			this.toLocationId = toLocationId;
	}



	/**
	 * Return the value associated with the column: TO_OUTLET
	 */

	public java.lang.String getToOultetId () {
			return toOultetId;
	}



	/**
	 * Set the value related to the column: TO_OUTLET
	 * @param toOultetId the TO_OUTLET value
	 */
			public void setToOultetId (java.lang.String toOultetId) {
			this.toOultetId = toOultetId;
	}



	/**
	 * Return the value associated with the column: VENDOR_ID
	 */

	public java.lang.String getVendorId () {
			return vendorId;
	}



	/**
	 * Set the value related to the column: VENDOR_ID
	 * @param vendorId the VENDOR_ID value
	 */
			public void setVendorId (java.lang.String vendorId) {
			this.vendorId = vendorId;
	}



	/**
	 * Return the value associated with the column: USER_ID
	 */

	public java.lang.String getUserId () {
			return userId;
	}



	/**
	 * Set the value related to the column: USER_ID
	 * @param userId the USER_ID value
	 */
			public void setUserId (java.lang.String userId) {
			this.userId = userId;
	}



	/**
	 * Return the value associated with the column: TRAN_TYPE
	 */

	public java.lang.Integer getType () {
						return type == null ? Integer.valueOf(0) : type;
		}



	/**
	 * Set the value related to the column: TRAN_TYPE
	 * @param type the TRAN_TYPE value
	 */
			public void setType (java.lang.Integer type) {
			this.type = type;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: MENU_ITEM_ID
	 */

	public com.floreantpos.model.MenuItem getMenuItem () {
			return menuItem;
	}



	/**
	 * Set the value related to the column: MENU_ITEM_ID
	 * @param menuItem the MENU_ITEM_ID value
	 */
			public void setMenuItem (com.floreantpos.model.MenuItem menuItem) {
			this.menuItem = menuItem;
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.InventoryTransaction)) return false;
		else {
			com.floreantpos.model.InventoryTransaction inventoryTransaction = (com.floreantpos.model.InventoryTransaction) obj;
			if (null == this.getId() || null == inventoryTransaction.getId()) return this == obj;
			else return (this.getId().equals(inventoryTransaction.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}