package com.floreantpos.report.model;

import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.floreantpos.POSConstants;
import com.floreantpos.model.Agent;
import com.floreantpos.model.AgentTypeEnum;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Doctor;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.NumberUtil;

public class PaymentReceivedReportData {
	public static String PROP_TICKET_ID = "ticketId"; //$NON-NLS-1$
	public static String PROP_TICKET = "ticket"; //$NON-NLS-1$
	public static String PROP_REFERRAL_ID = "referralId"; //$NON-NLS-1$

	private String paymentTypeString;
	private String customPaymentName;
	private String outletId;
	private String userId;
	private String id;
	private String transactionType;
	private Date transactionTime;
	private Double amount;
	private String ticketId;
	private Ticket ticket;
	private String entityId;
	private String entityType;

	private Date orderDate;
	private String referralType;
	private String referralBy;
	private String referralId;

	public PaymentReceivedReportData() {
	}

	public String getPaymentTypeString() {
		return paymentTypeString;
	}

	public String getPaymentTypeStringDisplay() {
		PaymentType paymentType = null;
		try {
			paymentType = PaymentType.valueOf(paymentTypeString);
		} catch (Exception e) {
			paymentType = PaymentType.fromDisplayString(paymentTypeString);
		}

		if (paymentType == null) {
			return "";
		}
		String paymentTypeStr;
		if (paymentType.equals(PaymentType.CUSTOM_PAYMENT)) {
			String customPaymentName = getCustomPaymentName();
			paymentTypeStr = StringUtils.isEmpty(customPaymentName) ? paymentType.getDisplayString() : customPaymentName;
		}
		else {
			paymentTypeStr = paymentType.getDisplayString();
		}

		return paymentTypeStr;
	}

	public void setPaymentTypeString(String paymentTypeString) {
		this.paymentTypeString = paymentTypeString;
	}

	public String getCustomPaymentName() {
		return customPaymentName;
	}

	public void setCustomPaymentName(String customPaymentName) {
		this.customPaymentName = customPaymentName;
	}

	public String getOutletId() {
		return outletId;
	}

	public void setOutletId(String outletId) {
		this.outletId = outletId;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getUserDisplay() {
		User user = DataProvider.get().getUserById(getUserId(), getOutletId());
		if (user == null) {
			return POSConstants.NONE;
		}
		return user.getFullName();
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public Date getTransactionTime() {
		return transactionTime;
	}

	public void setTransactionTime(Date transactionTime) {
		this.transactionTime = transactionTime;
	}

	public String getTransactionTimeDisplay() {
		return DateUtil.formatDateWithTime(DateUtil.convertServerTimeToBrowserTime(getTransactionTime()));
	}

	public String getOrderDateDisplay() {
		if (orderDate == null) {
			orderDate = getOrderDate();
		}
		if (orderDate == null) {
			return "";
		}
		return DateUtil.formatDateWithTime(DateUtil.convertServerTimeToBrowserTime(orderDate));
	}

	public void setOrderDate(Date orderDate) {
		this.orderDate = orderDate;
	}

	public Date getOrderDate() {
		Ticket ticket = getTicket();
		return orderDate = (ticket != null ? ticket.getCreateDate() : null);
	}

	public Double getAmount() {
		return amount;
	}

	public void setAmount(Double amount) {
		this.amount = amount;
	}

	public String getAmountDisplay() {
		return NumberUtil.formatAmount(NumberUtil.round(getAmount()));

	}

	public String getTransactionType() {
		return transactionType;
	}

	public void setTransactionType(String transactionType) {
		this.transactionType = transactionType;
	}

	public String getTicketId() {
		Ticket ticket = getTicket();
		return ticket != null ? ticket.getId() : null;
	}

	public Ticket getTicket() {
		if (ticket != null) {
			return ticket;
		}
		String ticketId = getEntityId();
		if (StringUtils.isNotBlank(ticketId) && Ticket.REF.equals(getEntityType())) {
			ticket = TicketDAO.getInstance().get(ticketId, getOutletId());
		}
		return ticket;
	}

	public void setTicket(Ticket ticket) {
		this.ticket = ticket;
	}

	public String getReferralType() {
		populateRefInfo();
		return referralType;
	}

	public void setReferralType(String referralType) {
		this.referralType = referralType;
	}

	public String getReferralBy() {
		populateRefInfo();
		return referralBy;
	}

	public void setReferralBy(String referralBy) {
		this.referralBy = referralBy;
	}

	public String getReferralId() {
		return referralId;
	}

	public void setReferralId(String referralId) {
		this.referralId = referralId;
	}

	private void populateRefInfo() {
		if (StringUtils.isNotBlank(referralBy)) {
			return;
		}

		if (StringUtils.isNotBlank(referralId)) {
			Customer referrer = CustomerDAO.getInstance().get(referralId);
			if (referrer != null) {
				setReferralBy(referrer.getName());
				if (referrer instanceof Agent) {
					String agentType = referrer.getAgentType();
					if (StringUtils.isNotBlank(agentType)) {
						setReferralType(AgentTypeEnum.fromString(agentType).getDisplayString());
					}
					else {
						setReferralType("Other");
					}
				}
				else if (referrer instanceof Doctor) {
					if (referrer.getIndorDoctor()) {
						setReferralType(AgentTypeEnum.INDOOR_DOCTOR.getDisplayString());
					}
					else {
						setReferralType(AgentTypeEnum.OUTDOOR_DOCTOR.getDisplayString());
					}
				}
			}
			else {
				setReferralType("Self");
				setReferralBy(""); //$NON-NLS-1$
			}
		}
		else {
			setReferralType("Self");
			setReferralBy(""); //$NON-NLS-1$
		}
	}

	public String getEntityId() {
		return entityId;
	}

	public void setEntityId(String entityId) {
		this.entityId = entityId;
	}

	public String getEntityType() {
		return entityType;
	}

	public void setEntityType(String entityType) {
		this.entityType = entityType;
	}
}
