package com.floreantpos.services;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.DosageForms;
import com.floreantpos.model.Manufacturer;
import com.floreantpos.model.MedGenerics;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;

public class MenuItemService {
	public static String getManufacturerName(MenuItem menuItem) {
		String manufacturerName = menuItem.getProperty(MenuItem.MANUFACTURER_NAME);
		if (StringUtils.isNotBlank(manufacturerName)) {
			return manufacturerName;
		}
		String manufactureId = menuItem.getManufactureId();
		if (StringUtils.isNotBlank(manufactureId)) {
			Manufacturer manufacture = (Manufacturer) DataProvider.get().getObjectOf(Manufacturer.class, manufactureId);
			menuItem = MenuItemDAO.getInstance().get(menuItem.getId());
			menuItem.setManufacturer(manufacture);
			MenuItemDAO.getInstance().saveOrUpdate(menuItem);
			if (manufacture != null) {
				return manufacture.getName();
			}
		}
		return StringUtils.EMPTY;
	}

	public static String getDosageFormsName(MenuItem menuItem) {
		String dosageFormsName = menuItem.getProperty(MenuItem.DOSAGE_FORMS_NAME);
		if (StringUtils.isNotBlank(dosageFormsName)) {
			return dosageFormsName;
		}
		String dosageFormsId = menuItem.getDosageFormsId();
		if (StringUtils.isNotBlank(dosageFormsId)) {
			DosageForms dosageForms = (DosageForms) DataProvider.get().getObjectOf(DosageForms.class, dosageFormsId);
			menuItem = MenuItemDAO.getInstance().get(menuItem.getId());
			menuItem.setDosageForms(dosageForms);
			MenuItemDAO.getInstance().saveOrUpdate(menuItem);
			if (dosageForms != null) {
				return dosageForms.getName();
			}
		}
		return StringUtils.EMPTY;
	}

	public static String getMedGenericsName(MenuItem menuItem) {
		String genericsName = menuItem.getProperty(MenuItem.MED_GENERICS_NAME);
		if (StringUtils.isNotBlank(genericsName)) {
			return genericsName;
		}
		String medGenericId = menuItem.getMedGenericId();
		if (StringUtils.isNotBlank(medGenericId)) {
			MedGenerics medGenerics = (MedGenerics) DataProvider.get().getObjectOf(MedGenerics.class, medGenericId);
			menuItem = MenuItemDAO.getInstance().get(menuItem.getId());
			menuItem.setMedGenerics(medGenerics);
			MenuItemDAO.getInstance().saveOrUpdate(menuItem);
			if (medGenerics != null) {
				return medGenerics.getName();
			}
		}
		return StringUtils.EMPTY;
	}
}