package com.floreantpos.model;

import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseVoidItem;
import com.floreantpos.model.util.DataProvider;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "voidedModifiers", "printerGroup", "voidByUser" })
@XmlRootElement
public class VoidItem extends BaseVoidItem implements TimedModel {
	private static final long serialVersionUID = 1L;
	public static final String PROP_ID = "id"; //$NON-NLS-1$
	public static final String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$

	private String itemId;
	private boolean cooked;
	private Double taxAmount;
	private List<VoidItem> voidedModifiers;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public VoidItem() {
	}

	/**
	 * Constructor for primary key
	 */
	public VoidItem(java.lang.String id, java.lang.String outletId) {

		super(id, outletId);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public VoidItem(java.lang.String voidReason, boolean wasted, double qty) {
		setVoidReason(voidReason);
		setItemWasted(wasted);
		setQuantity(qty);
	}

	public String getItemId() {
		return itemId;
	}

	public void setItemId(String itemId) {
		this.itemId = itemId;
	}

	public boolean isCooked() {
		return cooked;
	}

	public void setCooked(boolean b) {
		this.cooked = b;
	}

	public Double getTaxAmount() {
		return taxAmount == null ? new Double(0) : taxAmount;
	}

	public void setTaxAmount(Double taxAmount) {
		this.taxAmount = taxAmount;
	}

	public void setVoidModifiers(List<VoidItem> modifierVoidItems) {
		this.voidedModifiers = modifierVoidItems;
	}

	@XmlTransient
	public List<VoidItem> getVoidedModifiers() {
		return voidedModifiers;
	}

	@XmlTransient
	public PrinterGroup getPrinterGroup() {
		if (super.getPrinterGroupId() == null) {
			return null;
		}
		return DataProvider.get().getPrinterGroupById(getPrinterGroupId());
	}

	public void setPrinterGroup(PrinterGroup printerGroup) {
		setPrinterGroupId(printerGroup == null ? null : printerGroup.getId());
	}

	public void setTerminal(Terminal terminal) {
		setTerminalId(terminal == null ? null : terminal.getId());
	}

	@XmlTransient
	public User getVoidByUser() {
		if (getVoidByUserId() == null) {
			return null;
		}
		return DataProvider.get().getUserById(getVoidByUserId(), getOutletId());
	}

	public void setVoidByUser(User user) {
		setVoidByUserId(user == null ? null : user.getId());
	}
}