package com.orocube.medlogics.chemo;

import java.io.Serializable;

/**
 * Helper POJO for storing medication information for chemotherapy
 * Contains medication details like name, dose, route, frequency, etc.
 */
public class ChemoMedicationItem implements Serializable {
	private static final long serialVersionUID = 1L;

	private String medicationId;
	private String medicationName;
	private String dose;
	private String unit;
	private String route;
	private String frequency;
	private String duration;
	private String instructions;

	public ChemoMedicationItem() {
	}

	public ChemoMedicationItem(String medicationName, String dose, String unit) {
		this.medicationName = medicationName;
		this.dose = dose;
		this.unit = unit;
	}

	public String getMedicationId() {
		return medicationId;
	}

	public void setMedicationId(String medicationId) {
		this.medicationId = medicationId;
	}

	public String getMedicationName() {
		return medicationName;
	}

	public void setMedicationName(String medicationName) {
		this.medicationName = medicationName;
	}

	public String getDose() {
		return dose;
	}

	public void setDose(String dose) {
		this.dose = dose;
	}

	public String getUnit() {
		return unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	public String getRoute() {
		return route;
	}

	public void setRoute(String route) {
		this.route = route;
	}

	public String getFrequency() {
		return frequency;
	}

	public void setFrequency(String frequency) {
		this.frequency = frequency;
	}

	public String getDuration() {
		return duration;
	}

	public void setDuration(String duration) {
		this.duration = duration;
	}

	public String getInstructions() {
		return instructions;
	}

	public void setInstructions(String instructions) {
		this.instructions = instructions;
	}

	@Override
	public String toString() {
		return "ChemoMedicationItem{" +
				"medicationId='" + medicationId + '\'' +
				", medicationName='" + medicationName + '\'' +
				", dose='" + dose + '\'' +
				", unit='" + unit + '\'' +
				", route='" + route + '\'' +
				", frequency='" + frequency + '\'' +
				", duration='" + duration + '\'' +
				", instructions='" + instructions + '\'' +
				'}';
	}
}
