package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the REQUISITION table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="REQUISITION"
 */

public abstract class BaseRequisition  implements Comparable, Serializable {

	public static String REF = "Requisition"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_APPROVED_DATE = "approvedDate"; //$NON-NLS-1$
	public static String PROP_AMOUNT = "amount"; //$NON-NLS-1$
	public static String PROP_PROJECT_ID = "projectId"; //$NON-NLS-1$
	public static String PROP_DONE_BY_USER_ID = "doneByUserId"; //$NON-NLS-1$
	public static String PROP_APPROVED_BY_USER_ID = "approvedByUserId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_CREATE_DATE = "createDate"; //$NON-NLS-1$
	public static String PROP_ITEMS_JSON = "itemsJson"; //$NON-NLS-1$
	public static String PROP_ORDER_STATUS = "orderStatus"; //$NON-NLS-1$
	public static String PROP_CREATED_BY_USER_ID = "createdByUserId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_USER_ID = "userId"; //$NON-NLS-1$
	public static String PROP_DONE_DATE = "doneDate"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseRequisition () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseRequisition (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date createDate;
				private java.util.Date approvedDate;
				private java.util.Date doneDate;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.Integer orderStatus;
				private java.lang.String projectId;
				private java.lang.String userId;
				private java.lang.String createdByUserId;
				private java.lang.String approvedByUserId;
				private java.lang.String doneByUserId;
				private java.lang.String outletId;
				private java.lang.Double amount;
				private java.lang.String itemsJson;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.QuotationIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: CREATE_DATE
	 */

	public java.util.Date getCreateDate () {
			return createDate;
	}



	/**
	 * Set the value related to the column: CREATE_DATE
	 * @param createDate the CREATE_DATE value
	 */
			public void setCreateDate (java.util.Date createDate) {
			this.createDate = createDate;
	}



	/**
	 * Return the value associated with the column: APPROVED_DATE
	 */

	public java.util.Date getApprovedDate () {
			return approvedDate;
	}



	/**
	 * Set the value related to the column: APPROVED_DATE
	 * @param approvedDate the APPROVED_DATE value
	 */
			public void setApprovedDate (java.util.Date approvedDate) {
			this.approvedDate = approvedDate;
	}



	/**
	 * Return the value associated with the column: DONE_DATE
	 */

	public java.util.Date getDoneDate () {
			return doneDate;
	}



	/**
	 * Set the value related to the column: DONE_DATE
	 * @param doneDate the DONE_DATE value
	 */
			public void setDoneDate (java.util.Date doneDate) {
			this.doneDate = doneDate;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: ORDER_STATUS
	 */

	public java.lang.Integer getOrderStatus () {
						return orderStatus == null ? Integer.valueOf(0) : orderStatus;
		}



	/**
	 * Set the value related to the column: ORDER_STATUS
	 * @param orderStatus the ORDER_STATUS value
	 */
			public void setOrderStatus (java.lang.Integer orderStatus) {
			this.orderStatus = orderStatus;
	}



	/**
	 * Return the value associated with the column: PROJECT_ID
	 */

	public java.lang.String getProjectId () {
			return projectId;
	}



	/**
	 * Set the value related to the column: PROJECT_ID
	 * @param projectId the PROJECT_ID value
	 */
			public void setProjectId (java.lang.String projectId) {
			this.projectId = projectId;
	}



	/**
	 * Return the value associated with the column: USER_ID
	 */

	public java.lang.String getUserId () {
			return userId;
	}



	/**
	 * Set the value related to the column: USER_ID
	 * @param userId the USER_ID value
	 */
			public void setUserId (java.lang.String userId) {
			this.userId = userId;
	}



	/**
	 * Return the value associated with the column: CREATED_BY_USER_ID
	 */

	public java.lang.String getCreatedByUserId () {
			return createdByUserId;
	}



	/**
	 * Set the value related to the column: CREATED_BY_USER_ID
	 * @param createdByUserId the CREATED_BY_USER_ID value
	 */
			public void setCreatedByUserId (java.lang.String createdByUserId) {
			this.createdByUserId = createdByUserId;
	}



	/**
	 * Return the value associated with the column: APPROVED_BY_USER_ID
	 */

	public java.lang.String getApprovedByUserId () {
			return approvedByUserId;
	}



	/**
	 * Set the value related to the column: APPROVED_BY_USER_ID
	 * @param approvedByUserId the APPROVED_BY_USER_ID value
	 */
			public void setApprovedByUserId (java.lang.String approvedByUserId) {
			this.approvedByUserId = approvedByUserId;
	}



	/**
	 * Return the value associated with the column: DONE_BY_USER_ID
	 */

	public java.lang.String getDoneByUserId () {
			return doneByUserId;
	}



	/**
	 * Set the value related to the column: DONE_BY_USER_ID
	 * @param doneByUserId the DONE_BY_USER_ID value
	 */
			public void setDoneByUserId (java.lang.String doneByUserId) {
			this.doneByUserId = doneByUserId;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: AMOUNT
	 */

	public java.lang.Double getAmount () {
						return amount == null ? Double.valueOf(0) : amount;
		}



	/**
	 * Set the value related to the column: AMOUNT
	 * @param amount the AMOUNT value
	 */
			public void setAmount (java.lang.Double amount) {
			this.amount = amount;
	}



	/**
	 * Return the value associated with the column: ITEMS_JSON
	 */

	public java.lang.String getItemsJson () {
			return itemsJson;
	}



	/**
	 * Set the value related to the column: ITEMS_JSON
	 * @param itemsJson the ITEMS_JSON value
	 */
			public void setItemsJson (java.lang.String itemsJson) {
			this.itemsJson = itemsJson;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Requisition)) return false;
		else {
			com.floreantpos.model.Requisition requisition = (com.floreantpos.model.Requisition) obj;
			if (null == this.getId() || null == requisition.getId()) return this == obj;
			else return (this.getId().equals(requisition.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}