package com.floreantpos.model.util;

public enum EnumDateFormat {
	FORMAT1("30-12-19", "dd-MM-yy"), FORMAT2("30-12-2019", "dd-MM-yyyy"), FORMAT3("30 Dec 19", "dd MMM yy"), FORMAT4("30 Dec 2019", "dd MMM yyyy"), FORMAT5( //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
			"12-30-19", "MM-dd-YY"), FORMAT6("12-30-2019", "MM-dd-yyyy"), FORMAT7("Dec-30-19",
					"MMM dd yy"), FORMAT8("Dec-30-2019", "MMM dd yyyy"), FORMAT9("Dec-30", "MMM dd"), FORMAT10("Dec-30,19", "MMM dd,yy"); //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$

	private String displayText;
	private String format;

	private EnumDateFormat(String display, String format) {
		this.displayText = display;
		this.format = format;
	}

	public String getDisplayText() {
		return displayText;
	}

	public String getFormat() {
		return format;
	}

	public static EnumDateFormat get(String value) {
		switch (value) {
			case "dd-MM-yy": //$NON-NLS-1$
				return FORMAT1;
			case "dd-MM-yyyy": //$NON-NLS-1$
				return FORMAT2;
			case "dd MMM yy": //$NON-NLS-1$
				return FORMAT3;
			case "dd MMM yyyy": //$NON-NLS-1$
				return FORMAT4;
			case "MM-dd-YY": //$NON-NLS-1$
				return FORMAT5;
			case "MM-dd-yyyy": //$NON-NLS-1$
				return FORMAT6;
			case "MMM dd yy": //$NON-NLS-1$
				return FORMAT7;
			case "MMM dd yyyy": //$NON-NLS-1$
				return FORMAT8;
			case "MMM dd": //$NON-NLS-1$
				return FORMAT9;
			case "MMM dd,yy": //$NON-NLS-1$
				return FORMAT10;

			default:
				return null;
		}
	}

	public String toString() {
		return getDisplayText();
	}
}
