package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the GUEST_CHECK_PRINT table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="GUEST_CHECK_PRINT"
 */

public abstract class BaseGuestCheckPrint  implements Comparable, Serializable {

	public static String REF = "GuestCheckPrint"; //$NON-NLS-1$
	public static String PROP_TICKET_TOTAL = "ticketTotal"; //$NON-NLS-1$
	public static String PROP_TICKET_ID = "ticketId"; //$NON-NLS-1$
	public static String PROP_USER = "user"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_TABLE_NO = "tableNo"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_PRINT_TIME = "printTime"; //$NON-NLS-1$


	// constructors
	public BaseGuestCheckPrint () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseGuestCheckPrint (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String ticketId;
				private java.lang.String tableNo;
				private java.lang.Double ticketTotal;
				private java.util.Date printTime;
	
	// many to one
	private com.floreantpos.model.User user;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: TICKET_ID
	 */

	public java.lang.String getTicketId () {
			return ticketId;
	}



	/**
	 * Set the value related to the column: TICKET_ID
	 * @param ticketId the TICKET_ID value
	 */
			public void setTicketId (java.lang.String ticketId) {
			this.ticketId = ticketId;
	}



	/**
	 * Return the value associated with the column: TABLE_NO
	 */

	public java.lang.String getTableNo () {
			return tableNo;
	}



	/**
	 * Set the value related to the column: TABLE_NO
	 * @param tableNo the TABLE_NO value
	 */
			public void setTableNo (java.lang.String tableNo) {
			this.tableNo = tableNo;
	}



	/**
	 * Return the value associated with the column: TICKET_TOTAL
	 */

	public java.lang.Double getTicketTotal () {
						return ticketTotal == null ? Double.valueOf(0) : ticketTotal;
		}



	/**
	 * Set the value related to the column: TICKET_TOTAL
	 * @param ticketTotal the TICKET_TOTAL value
	 */
			public void setTicketTotal (java.lang.Double ticketTotal) {
			this.ticketTotal = ticketTotal;
	}



	/**
	 * Return the value associated with the column: PRINT_TIME
	 */

	public java.util.Date getPrintTime () {
			return printTime;
	}



	/**
	 * Set the value related to the column: PRINT_TIME
	 * @param printTime the PRINT_TIME value
	 */
			public void setPrintTime (java.util.Date printTime) {
			this.printTime = printTime;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public com.floreantpos.model.User getUser () {
			return user;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param user the OUTLET_ID value
	 */
			public void setUser (com.floreantpos.model.User user) {
			this.user = user;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.GuestCheckPrint)) return false;
		else {
			com.floreantpos.model.GuestCheckPrint guestCheckPrint = (com.floreantpos.model.GuestCheckPrint) obj;
			if (null == this.getId() || null == guestCheckPrint.getId()) return this == obj;
			else return (this.getId().equals(guestCheckPrint.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}