package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.InvoiceTemplate;


public class InvoiceTemplateDAO extends BaseInvoiceTemplateDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public InvoiceTemplateDAO () {}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	public void delete(Object obj, Session s) throws HibernateException {
		InvoiceTemplate template = (InvoiceTemplate) obj;
		template.setDeleted(true);
		update(template, s);
	}

	public InvoiceTemplate findInvoiceTemplateByName(String templateName, String outletId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(InvoiceTemplate.class);
			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(InvoiceTemplate.PROP_TEMPLATE_NAME, templateName));
			if (StringUtils.isNotBlank(outletId)) {
				criteria.add(Restrictions.eq(InvoiceTemplate.PROP_OUTLET_ID, outletId));
			}
			List list = criteria.list();
			if (!list.isEmpty()) {

				return (InvoiceTemplate) list.get(0);
			}
		}
		return null;
	}

}
