package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseChemoProcessNote;
import com.floreantpos.model.dao.StoreDAO;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "propertiesContainer", "chemoCycle" })
@XmlRootElement
public class ChemoProcessNote extends BaseChemoProcessNote implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ChemoProcessNote() {
		setCreatedDate(StoreDAO.getServerTimestamp());
	}

	/**
	 * Constructor for primary key
	 */
	public ChemoProcessNote(java.lang.String id) {
		super(id);
		setCreatedDate(StoreDAO.getServerTimestamp());
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	@Override
	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	@Override
	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	@Override
	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	@Override
	public String toString() {
		if (getProcessDate() != null) {
			return "ChemoProcessNote[" + getId() + "] - " + getProcessDate();
		}
		return "ChemoProcessNote[" + getId() + "]";
	}
}
