package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the RECEPIES table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="RECEPIES"
 */

public abstract class BaseSubRecipe  implements Comparable, Serializable {

	public static String REF = "SubRecipe"; //$NON-NLS-1$
	public static String PROP_RECIPE = "recipe"; //$NON-NLS-1$
	public static String PROP_PORTION = "portion"; //$NON-NLS-1$


	// constructors
	public BaseSubRecipe () {
		initialize();
	}

	protected void initialize () {}



	// fields
		protected java.lang.Double portion;

	// many to one
	private com.floreantpos.model.Recepie recipe;






	/**
	 * Return the value associated with the column: PORTION
	 */
		public java.lang.Double getPortion () {
									return portion == null ? Double.valueOf(0) : portion;
					}

	/**
	 * Set the value related to the column: PORTION
	 * @param portion the PORTION value
	 */
	public void setPortion (java.lang.Double portion) {
		this.portion = portion;
	}



	/**
	 * Return the value associated with the column: SUB_RECIPE_ID
	 */
		public com.floreantpos.model.Recepie getRecipe () {
					return recipe;
			}

	/**
	 * Set the value related to the column: SUB_RECIPE_ID
	 * @param recipe the SUB_RECIPE_ID value
	 */
	public void setRecipe (com.floreantpos.model.Recepie recipe) {
		this.recipe = recipe;
	}







	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}