package com.floreantpos.model.util.pricecalc;

import com.floreantpos.model.Discount;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;

public interface TicketCalc {
	void calculatePrice(Ticket ticket);

	void calculateRefundAmount(Ticket ticket);
	
	double applyFloridaTaxRuleV2(Ticket ticket, double subtotal, double totalTaxAmount);

	TicketDiscount convertToTicketDiscount(Discount discount, Ticket ticket);

	TicketDiscount buildLoyaltyDiscount(Ticket ticket);

	double calculateDiscountFromType(Ticket ticket, TicketDiscount coupon, double subtotal);

	void voidItem(Ticket ticket, TicketItem ticketItem, String voidReason, boolean itemWasted, double quantity);

	void voidReturnedItem(TicketItem voidTicketItem, String voidReason, boolean itemWasted);

	TicketItem undoVoidItem(Ticket ticket, TicketItem voidedTicketItem);

	void mergeTicket(Ticket currentTicket, Ticket localTicket);
}
