/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.ArrayList;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;

public class OrderDataSource extends AbstractReportDataSource {

	public OrderDataSource(PurchaseOrder order) {
		super(new String[] { "itemSL", "itemImage", "itemName", "itemQty", "unit", "itemPrice", "itemSubtotal", "itemNote" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
		setOrder(order);
	}

	private void setOrder(PurchaseOrder order) {
		ArrayList<PurchaseOrderItem> rows = new ArrayList<PurchaseOrderItem>();
		rows.addAll(order.getOrderItems());
		setRows(rows);
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		PurchaseOrderItem item = (PurchaseOrderItem) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return String.valueOf(rowIndex + 1);

			case 1:
				return null;
			case 2:
				String name = item.getName();
				if (StringUtils.isNotBlank(item.getDescription())) {
					name += "<br><span style=\"font-size:6px;\">" + item.getDescription() + "</span>";
				}
				return name;

			case 3:
				return item.getQuantityDisplay();

			case 4:
				return item.getUnitCodeDisplay();

			case 5:
				return item.getCostDisplay();

			case 6:
				return item.getTotalDisplay();

			case 7:
				return item.getNote();
		}

		return null;
	}
}
