package com.floreantpos.model;

import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseChemoCycle;
import com.floreantpos.model.dao.StoreDAO;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.orocube.medlogics.chemo.ChemoCycleStatus;
import com.orocube.medlogics.chemo.ChemoDate;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "propertiesContainer", "chemotherapy" })
@XmlRootElement
public class ChemoCycle extends BaseChemoCycle implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ChemoCycle() {
		setCreatedDate(StoreDAO.getServerTimestamp());
	}

	/**
	 * Constructor for primary key
	 */
	public ChemoCycle(java.lang.String id) {
		super(id);
		setCreatedDate(StoreDAO.getServerTimestamp());
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	@Override
	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	@Override
	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	@Override
	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	// Helper methods for ChemoDate objects (day1-day7)
	// These methods serialize/deserialize ChemoDate objects to/from JSON strings

	public ChemoDate getChemoDateForDay1() {
		String json = super.getDayOneJson();
		if (StringUtils.isEmpty(json)) {
			return null;
		}
		return new Gson().fromJson(json, ChemoDate.class);
	}

	public void setChemoDateForDay1(ChemoDate chemoDate) {
		if (chemoDate == null) {
			super.setDayOneJson(null);
		} else {
			super.setDayOneJson(new Gson().toJson(chemoDate));
		}
	}

	public ChemoDate getChemoDateForDay2() {
		String json = super.getDayTwoJson();
		if (StringUtils.isEmpty(json)) {
			return null;
		}
		return new Gson().fromJson(json, ChemoDate.class);
	}

	public void setChemoDateForDay2(ChemoDate chemoDate) {
		if (chemoDate == null) {
			super.setDayTwoJson(null);
		} else {
			super.setDayTwoJson(new Gson().toJson(chemoDate));
		}
	}

	public ChemoDate getChemoDateForDay3() {
		String json = super.getDayThreeJson();
		if (StringUtils.isEmpty(json)) {
			return null;
		}
		return new Gson().fromJson(json, ChemoDate.class);
	}

	public void setChemoDateForDay3(ChemoDate chemoDate) {
		if (chemoDate == null) {
			super.setDayThreeJson(null);
		} else {
			super.setDayThreeJson(new Gson().toJson(chemoDate));
		}
	}

	public ChemoDate getChemoDateForDay4() {
		String json = super.getDayFourJson();
		if (StringUtils.isEmpty(json)) {
			return null;
		}
		return new Gson().fromJson(json, ChemoDate.class);
	}

	public void setChemoDateForDay4(ChemoDate chemoDate) {
		if (chemoDate == null) {
			super.setDayFourJson(null);
		} else {
			super.setDayFourJson(new Gson().toJson(chemoDate));
		}
	}

	public ChemoDate getChemoDateForDay5() {
		String json = super.getDayFiveJson();
		if (StringUtils.isEmpty(json)) {
			return null;
		}
		return new Gson().fromJson(json, ChemoDate.class);
	}

	public void setChemoDateForDay5(ChemoDate chemoDate) {
		if (chemoDate == null) {
			super.setDayFiveJson(null);
		} else {
			super.setDayFiveJson(new Gson().toJson(chemoDate));
		}
	}

	public ChemoDate getChemoDateForDay6() {
		String json = super.getDaySixJson();
		if (StringUtils.isEmpty(json)) {
			return null;
		}
		return new Gson().fromJson(json, ChemoDate.class);
	}

	public void setChemoDateForDay6(ChemoDate chemoDate) {
		if (chemoDate == null) {
			super.setDaySixJson(null);
		} else {
			super.setDaySixJson(new Gson().toJson(chemoDate));
		}
	}

	public ChemoDate getChemoDateForDay7() {
		String json = super.getDaySevenJson();
		if (StringUtils.isEmpty(json)) {
			return null;
		}
		return new Gson().fromJson(json, ChemoDate.class);
	}

	public void setChemoDateForDay7(ChemoDate chemoDate) {
		if (chemoDate == null) {
			super.setDaySevenJson(null);
		} else {
			super.setDaySevenJson(new Gson().toJson(chemoDate));
		}
	}

	// Additional helper methods
	public Date getStartDate() {
		String startDate = getProperty("startDate");
		if (StringUtils.isEmpty(startDate)) {
			return null;
		}
		return new Gson().fromJson(startDate, Date.class);
	}

	public void setStartDate(Date startDate) {
		if (startDate == null) {
			removeProperty("startDate");
		}
		else {
			addProperty("startDate", new Gson().toJson(startDate));
		}
	}

	public Date getEndDate() {
		String endDate = getProperty("endDate");
		if (StringUtils.isEmpty(endDate)) {
			return null;
		}
		return new Gson().fromJson(endDate, Date.class);
	}

	public void setEndDate(Date endDate) {
		if (endDate == null) {
			removeProperty("endDate");
		}
		else {
			addProperty("endDate", new Gson().toJson(endDate));
		}
	}

	public Date getNextCycleDate() {
		String nextCycleDate = getProperty("nextCycleDate");
		if (StringUtils.isEmpty(nextCycleDate)) {
			return null;
		}
		return new Gson().fromJson(nextCycleDate, Date.class);
	}

	public void setNextCycleDate(Date nextCycleDate) {
		if (nextCycleDate == null) {
			removeProperty("nextCycleDate");
		}
		else {
			addProperty("nextCycleDate", new Gson().toJson(nextCycleDate));
		}
	}

	public String getDelayReason() {
		return getProperty("delayReason", "");
	}

	public void setDelayReason(String delayReason) {
		if (StringUtils.isEmpty(delayReason)) {
			removeProperty("delayReason");
		}
		else {
			addProperty("delayReason", delayReason);
		}
	}

	// Helper methods for report generation
	public String getCycleName() {
		Integer cycleNum = getCycleNumber();
		if (cycleNum != null) {
			// Convert to ordinal: 1st, 2nd, 3rd, 4th, etc.
			String suffix = "th";
			int mod100 = cycleNum % 100;
			if (mod100 < 11 || mod100 > 13) {
				int mod10 = cycleNum % 10;
				if (mod10 == 1) suffix = "st";
				else if (mod10 == 2) suffix = "nd";
				else if (mod10 == 3) suffix = "rd";
			}
			return cycleNum + suffix;
		}
		return "";
	}

	public java.util.List<ChemoDate> getDaysList() {
		java.util.List<ChemoDate> days = new java.util.ArrayList<>();
		ChemoDate day1 = getChemoDateForDay1();
		if (day1 != null) days.add(day1);
		ChemoDate day2 = getChemoDateForDay2();
		if (day2 != null) days.add(day2);
		ChemoDate day3 = getChemoDateForDay3();
		if (day3 != null) days.add(day3);
		ChemoDate day4 = getChemoDateForDay4();
		if (day4 != null) days.add(day4);
		ChemoDate day5 = getChemoDateForDay5();
		if (day5 != null) days.add(day5);
		ChemoDate day6 = getChemoDateForDay6();
		if (day6 != null) days.add(day6);
		ChemoDate day7 = getChemoDateForDay7();
		if (day7 != null) days.add(day7);
		return days;
	}

	public String getPostponedReason() {
		return getProperty("postponedReason", "");
	}

	public void setPostponedReason(String reason) {
		if (StringUtils.isEmpty(reason)) {
			removeProperty("postponedReason");
		}
		else {
			addProperty("postponedReason", reason);
		}
	}

	/**
	 * Get the ChemoCycleStatus enum from the status string
	 * @return ChemoCycleStatus enum or null if status is not set or invalid
	 */
	public ChemoCycleStatus getChemoCycleStatus() {
		String status = getStatus();
		if (StringUtils.isEmpty(status)) {
			return null;
		}
		return ChemoCycleStatus.fromString(status);
	}

	/**
	 * Get the display string for the cycle status
	 * @return Display string for the status or empty string if status is not set
	 */
	public String getChemoCycleStatusDisplay() {
		ChemoCycleStatus status = getChemoCycleStatus();
		if (status != null) {
			return status.getDisplayString();
		}
		return "";
	}

	/**
	 * Get the single process note (first item from the list)
	 * Uses base class getProcessNotes() method
	 * @return ChemoProcessNote or null if list is empty
	 */
	public ChemoProcessNote getProcessNote() {
		java.util.List<ChemoProcessNote> list = getProcessNotes();
		if (list != null && !list.isEmpty()) {
			return list.get(0);
		}
		return null;
	}

	/**
	 * Set or update the single process note in the list
	 * Uses base class setProcessNotes() method
	 * @param processNote ChemoProcessNote to save (replaces existing item if any)
	 */
	public void setProcessNote(ChemoProcessNote processNote) {
		if (processNote == null) {
			setProcessNotes(null);
		}
		else {
			java.util.List<ChemoProcessNote> list = new java.util.ArrayList<>();
			list.add(processNote);
			setProcessNotes(list);
		}
	}

	@Override
	public String toString() {
		return "ChemoCycle[" + getId() + "] - Cycle " + getCycleNumber() + " - " + getStatus();
	}
}
