package com.floreantpos.model.base;

import java.io.Serializable;

/**
 * This is an object that contains data related to the CHEMOTHERAPY table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="CHEMOTHERAPY"
 */
public abstract class BaseChemotherapy implements Comparable, Serializable {

	public static String REF = "Chemotherapy"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_PATIENT_ID = "patientId"; //$NON-NLS-1$
	public static String PROP_PATIENT_VITALS = "patientVitals"; //$NON-NLS-1$
	public static String PROP_CHEMOTHERAPY_NAME = "chemotherapyName"; //$NON-NLS-1$
	public static String PROP_DOCTOR_ID = "doctorId"; //$NON-NLS-1$
	public static String PROP_LOG_JSON = "logJson"; //$NON-NLS-1$
	public static String PROP_PRE_CHEMO_MEDICATION_JSON = "preChemoMedicationJson"; //$NON-NLS-1$
	public static String PROP_CHEMO_MEDICATION_JSON = "chemoMedicationJson"; //$NON-NLS-1$
	public static String PROP_POST_CHEMO_MEDICATION_JSON = "postChemoMedicationJson"; //$NON-NLS-1$
	public static String PROP_OTHER_ASSOCIATED_MEDICATION_JSON = "otherAssociatedMedicationJson"; //$NON-NLS-1$
	public static String PROP_NUMBER_OF_INITIAL_CYCLES = "numberOfInitialCycles"; //$NON-NLS-1$
	public static String PROP_NUMBER_OF_CYCLES = "numberOfCycles"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_PERFORMER_ID = "performerId"; //$NON-NLS-1$
	public static String PROP_PERFORMER_NAME = "performerName"; //$NON-NLS-1$

	// constructors
	public BaseChemotherapy() {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseChemotherapy(java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize() {}

	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
	private java.lang.String patientId;
	private java.lang.String patientVitals;
	private java.lang.String chemotherapyName;
	private java.lang.String doctorId;
	private java.lang.String logJson;
	private java.lang.String preChemoMedicationJson;
	private java.lang.String chemoMedicationJson;
	private java.lang.String postChemoMedicationJson;
	private java.lang.String otherAssociatedMedicationJson;
	private java.lang.Integer numberOfInitialCycles;
	private java.lang.Integer numberOfCycles;
	private java.lang.String status;
	private java.lang.String outletId;
	private java.util.Date createdDate;
	private java.util.Date lastUpdateTime;
	private java.util.Date lastSyncTime;
	private java.lang.Boolean deleted;
	private java.lang.String properties;
	private java.lang.String performerId;
	private java.lang.String performerName;

	// collections
	private java.util.List<com.floreantpos.model.ChemoCycle> chemoCycles;

	/**
	 * Return the unique identifier of this class
	 * @hibernate.id
	 *  generator-class="com.floreantpos.util.UUIdGenerator"
	 *  column="ID"
	 */
	public java.lang.String getId() {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId(java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}

	/**
	 * Return the value associated with the column: PATIENT_ID
	 */
	public java.lang.String getPatientId() {
		return patientId;
	}

	/**
	 * Set the value related to the column: PATIENT_ID
	 * @param patientId the PATIENT_ID value
	 */
	public void setPatientId(java.lang.String patientId) {
		this.patientId = patientId;
	}

	/**
	 * Return the value associated with the column: PATIENT_VITALS
	 */
	public java.lang.String getPatientVitals() {
		return patientVitals;
	}

	/**
	 * Set the value related to the column: PATIENT_VITALS
	 * @param patientVitals the PATIENT_VITALS value
	 */
	public void setPatientVitals(java.lang.String patientVitals) {
		this.patientVitals = patientVitals;
	}

	/**
	 * Return the value associated with the column: CHEMOTHERAPY_NAME
	 */
	public java.lang.String getChemotherapyName() {
		return chemotherapyName;
	}

	/**
	 * Set the value related to the column: CHEMOTHERAPY_NAME
	 * @param chemotherapyName the CHEMOTHERAPY_NAME value
	 */
	public void setChemotherapyName(java.lang.String chemotherapyName) {
		this.chemotherapyName = chemotherapyName;
	}

	/**
	 * Return the value associated with the column: DOCTOR_ID
	 */
	public java.lang.String getDoctorId() {
		return doctorId;
	}

	/**
	 * Set the value related to the column: DOCTOR_ID
	 * @param doctorId the DOCTOR_ID value
	 */
	public void setDoctorId(java.lang.String doctorId) {
		this.doctorId = doctorId;
	}

	/**
	 * Return the value associated with the column: LOG_JSON
	 */
	public java.lang.String getLogJson() {
		return logJson;
	}

	/**
	 * Set the value related to the column: LOG_JSON
	 * @param logJson the LOG_JSON value
	 */
	public void setLogJson(java.lang.String logJson) {
		this.logJson = logJson;
	}

	/**
	 * Return the value associated with the column: PRE_CHEMO_MEDICATION_JSON
	 */
	public java.lang.String getPreChemoMedicationJson() {
		return preChemoMedicationJson;
	}

	/**
	 * Set the value related to the column: PRE_CHEMO_MEDICATION_JSON
	 * @param preChemoMedicationJson the PRE_CHEMO_MEDICATION_JSON value
	 */
	public void setPreChemoMedicationJson(java.lang.String preChemoMedicationJson) {
		this.preChemoMedicationJson = preChemoMedicationJson;
	}

	/**
	 * Return the value associated with the column: CHEMO_MEDICATION_JSON
	 */
	public java.lang.String getChemoMedicationJson() {
		return chemoMedicationJson;
	}

	/**
	 * Set the value related to the column: CHEMO_MEDICATION_JSON
	 * @param chemoMedicationJson the CHEMO_MEDICATION_JSON value
	 */
	public void setChemoMedicationJson(java.lang.String chemoMedicationJson) {
		this.chemoMedicationJson = chemoMedicationJson;
	}

	/**
	 * Return the value associated with the column: POST_CHEMO_MEDICATION_JSON
	 */
	public java.lang.String getPostChemoMedicationJson() {
		return postChemoMedicationJson;
	}

	/**
	 * Set the value related to the column: POST_CHEMO_MEDICATION_JSON
	 * @param postChemoMedicationJson the POST_CHEMO_MEDICATION_JSON value
	 */
	public void setPostChemoMedicationJson(java.lang.String postChemoMedicationJson) {
		this.postChemoMedicationJson = postChemoMedicationJson;
	}

	/**
	 * Return the value associated with the column: OTHER_MEDICATION_JSON
	 */
	public java.lang.String getOtherAssociatedMedicationJson() {
		return otherAssociatedMedicationJson;
	}

	/**
	 * Set the value related to the column: OTHER_MEDICATION_JSON
	 * @param otherAssociatedMedicationJson the OTHER_MEDICATION_JSON value
	 */
	public void setOtherAssociatedMedicationJson(java.lang.String otherAssociatedMedicationJson) {
		this.otherAssociatedMedicationJson = otherAssociatedMedicationJson;
	}

	/**
	 * Return the value associated with the column: INITIAL_CYCLES
	 */
	public java.lang.Integer getNumberOfInitialCycles() {
		return numberOfInitialCycles;
	}

	/**
	 * Set the value related to the column: INITIAL_CYCLES
	 * @param numberOfInitialCycles the INITIAL_CYCLES value
	 */
	public void setNumberOfInitialCycles(java.lang.Integer numberOfInitialCycles) {
		this.numberOfInitialCycles = numberOfInitialCycles;
	}

	/**
	 * Return the value associated with the column: NUMBER_OF_CYCLES
	 */
	public java.lang.Integer getNumberOfCycles() {
		return numberOfCycles;
	}

	/**
	 * Set the value related to the column: NUMBER_OF_CYCLES
	 * @param numberOfCycles the NUMBER_OF_CYCLES value
	 */
	public void setNumberOfCycles(java.lang.Integer numberOfCycles) {
		this.numberOfCycles = numberOfCycles;
	}

	/**
	 * Return the value associated with the column: STATUS
	 */
	public java.lang.String getStatus() {
		return status;
	}

	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
	public void setStatus(java.lang.String status) {
		this.status = status;
	}

	/**
	 * Return the value associated with the column: OUTLET_ID
	 */
	public java.lang.String getOutletId() {
		return outletId;
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
	public void setOutletId(java.lang.String outletId) {
		this.outletId = outletId;
	}

	/**
	 * Return the value associated with the column: CREATED_DATE
	 */
	public java.util.Date getCreatedDate() {
		return createdDate;
	}

	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
	public void setCreatedDate(java.util.Date createdDate) {
		this.createdDate = createdDate;
	}

	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */
	public java.util.Date getLastUpdateTime() {
		return lastUpdateTime;
	}

	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
	public void setLastUpdateTime(java.util.Date lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */
	public java.util.Date getLastSyncTime() {
		return lastSyncTime;
	}

	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
	public void setLastSyncTime(java.util.Date lastSyncTime) {
		this.lastSyncTime = lastSyncTime;
	}

	/**
	 * Return the value associated with the column: DELETED
	 */
	public java.lang.Boolean isDeleted() {
		return deleted == null ? Boolean.valueOf(false) : deleted;
	}

	public java.lang.Boolean getDeleted() {
		return deleted == null ? Boolean.valueOf(false) : deleted;
	}

	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
	public void setDeleted(java.lang.Boolean deleted) {
		this.deleted = deleted;
	}

	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue() {
		return "false";
	}

	/**
	 * Return the value associated with the column: PROPERTIES
	 */
	public java.lang.String getProperties() {
		return properties;
	}

	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
	public void setProperties(java.lang.String properties) {
		this.properties = properties;
	}

	/**
	 * Return the value associated with the column: PERFORMER_ID
	 */
	public java.lang.String getPerformerId() {
		return performerId;
	}

	/**
	 * Set the value related to the column: PERFORMER_ID
	 * @param performerId the PERFORMER_ID value
	 */
	public void setPerformerId(java.lang.String performerId) {
		this.performerId = performerId;
	}

	/**
	 * Return the value associated with the column: PERFORMER_NAME
	 */
	public java.lang.String getPerformerName() {
		return performerName;
	}

	/**
	 * Set the value related to the column: PERFORMER_NAME
	 * @param performerName the PERFORMER_NAME value
	 */
	public void setPerformerName(java.lang.String performerName) {
		this.performerName = performerName;
	}

	/**
	 * Return the value associated with the column: chemoCycles
	 */
	public java.util.List<com.floreantpos.model.ChemoCycle> getChemoCycles() {
		return chemoCycles;
	}

	/**
	 * Set the value related to the column: chemoCycles
	 * @param chemoCycles the chemoCycles value
	 */
	public void setChemoCycles(java.util.List<com.floreantpos.model.ChemoCycle> chemoCycles) {
		this.chemoCycles = chemoCycles;
	}

	public void addToChemoCycles(com.floreantpos.model.ChemoCycle chemoCycle) {
		if (null == getChemoCycles()) setChemoCycles(new java.util.ArrayList<com.floreantpos.model.ChemoCycle>());
		getChemoCycles().add(chemoCycle);
	}

	public boolean equals(Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Chemotherapy)) return false;
		else {
			com.floreantpos.model.Chemotherapy chemotherapy = (com.floreantpos.model.Chemotherapy) obj;
			if (null == this.getId() || null == chemotherapy.getId()) return this == obj;
			else return (this.getId().equals(chemotherapy.getId()));
		}
	}

	public int hashCode() {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo(Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString() {
		return super.toString();
	}
}
