package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseGlobalPrescription;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class GlobalPrescription extends BaseGlobalPrescription implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;

	private transient JsonObject propertiesContainer;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public GlobalPrescription() {
	}

	/**
	 * Constructor for primary key
	 */
	public GlobalPrescription(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	public void putPatient(Customer patient) {
		if (patient != null) {
			setPatientId(patient.getId());
			setPatientName(patient.getName());
			setPatientPhone(patient.getMobileNo());
		}
		else {
			setPatientId(null);
			setPatientName(null);
			setPatientPhone(null);
		}

	}

	public void putDoctor(Doctor doctor) {
		if (doctor != null) {
			setDoctorId(doctor.getId());
			setDoctorName(doctor.getName());
			setDoctorPhone(doctor.getMobileNo());
			putDoctorDesignation(doctor.getDoctorDesignation());
		}
		else {
			setDoctorId(null);
			setDoctorName(null);
			setDoctorPhone(null);
			putDoctorDesignation(null);
		}
	}
	
	public void putDoctorDesignation(String doctorDesignation) {
		addProperty("doctor.designation", doctorDesignation); //$NON-NLS-1$
	}

	public String getDoctorDesignation() {
		return getProperty("doctor.designation", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}
}