/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseRecepieItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown = true, value = { "recepie", "unit" })
public class RecepieItem extends BaseRecepieItem {
	private static final long serialVersionUID = 1L;

	public static String PROP_UNIT_TYPE = "unitType"; //$NON-NLS-1$

	private double cost;
	private transient IUnit unit;
	private String groupName;
	private String groupId;
	private String unitType;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public RecepieItem() {
	}

	/**
	 * Constructor for primary key
	 */
	public RecepieItem(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public double getCost() {
		return cost;
	}

	public void setCost(double cost) {
		this.cost = cost;
	}

	public void setUnit(IUnit unit) {
		this.unit = unit;
	}

	public IUnit getUnit() {
		MenuItem inventoryItem = getInventoryItem();
		String unitCode = getUnitCode();
		if (inventoryItem == null || StringUtils.isBlank(unitCode)) {
			unitCode = "each";
		}

		if (unit == null) {
			unit = DataProvider.get().getUnitById(unitCode, getUnitType());
		}
		return unit;
	}

	public void calculatePercentage() {
		MenuItem inventoryItem = getInventoryItem();
		if (inventoryItem != null) {
			MenuItemDAO.getInstance().initialize(inventoryItem);
			double baseUnitQuantity = inventoryItem.getBaseUnitQuantity(getUnitCode());
			setPercentage(getQuantity() * baseUnitQuantity * 100);
			setCost(inventoryItem.getCost() * getQuantity() * baseUnitQuantity);
		}
	}

	@Override
	public String toString() {
		MenuItem inventoryItem = super.getInventoryItem();
		if (inventoryItem == null) {
			return "";
		}
		return inventoryItem.toString();
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	public String getGroupName() {
		return groupName;
	}

	public String getGroupId() {
		return groupId;
	}

	public void setGroupId(String groupId) {
		this.groupId = groupId;
	}

	public String getUnitType() {
		return unitType;
	}

	public void setUnitType(String productType) {
		this.unitType = productType;
	}
}