package com.floreantpos.model.base;

import java.io.Serializable;

/**
 * This is an object that contains data related to the CHEMO_CYCLE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="CHEMO_CYCLE"
 */
public abstract class BaseChemoCycle implements Comparable, Serializable {

	public static String REF = "ChemoCycle"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_CHEMOTHERAPY = "chemotherapy"; //$NON-NLS-1$
	public static String PROP_CYCLE_NUMBER = "cycleNumber"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_DAY_ONE_JSON = "dayOneJson"; //$NON-NLS-1$
	public static String PROP_DAY_TWO_JSON = "dayTwoJson"; //$NON-NLS-1$
	public static String PROP_DAY_THREE_JSON = "dayThreeJson"; //$NON-NLS-1$
	public static String PROP_DAY_FOUR_JSON = "dayFourJson"; //$NON-NLS-1$
	public static String PROP_DAY_FIVE_JSON = "dayFiveJson"; //$NON-NLS-1$
	public static String PROP_DAY_SIX_JSON = "daySixJson"; //$NON-NLS-1$
	public static String PROP_DAY_SEVEN_JSON = "daySevenJson"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_PERFORMER_ID = "performerId"; //$NON-NLS-1$
	public static String PROP_PERFORMER_NAME = "performerName"; //$NON-NLS-1$

	// constructors
	public BaseChemoCycle() {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseChemoCycle(java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize() {}

	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
	private java.lang.Integer cycleNumber;
	private java.lang.String status;
	private java.lang.String dayOneJson;
	private java.lang.String dayTwoJson;
	private java.lang.String dayThreeJson;
	private java.lang.String dayFourJson;
	private java.lang.String dayFiveJson;
	private java.lang.String daySixJson;
	private java.lang.String daySevenJson;
	private java.lang.String outletId;
	private java.util.Date createdDate;
	private java.util.Date lastUpdateTime;
	private java.util.Date lastSyncTime;
	private java.lang.Boolean deleted;
	private java.lang.String properties;
	private java.lang.String performerId;
	private java.lang.String performerName;

	// many to one
	private com.floreantpos.model.Chemotherapy chemotherapy;

	// collections
	private java.util.List<com.floreantpos.model.ChemoProcessNote> processNotes;

	/**
	 * Return the unique identifier of this class
	 * @hibernate.id
	 *  generator-class="com.floreantpos.util.UUIdGenerator"
	 *  column="ID"
	 */
	public java.lang.String getId() {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId(java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}

	/**
	 * Return the value associated with the column: CHEMOTHERAPY_ID
	 */
	public com.floreantpos.model.Chemotherapy getChemotherapy() {
		return chemotherapy;
	}

	/**
	 * Set the value related to the column: CHEMOTHERAPY_ID
	 * @param chemotherapy the CHEMOTHERAPY_ID value
	 */
	public void setChemotherapy(com.floreantpos.model.Chemotherapy chemotherapy) {
		this.chemotherapy = chemotherapy;
	}

	/**
	 * Return the value associated with the column: CYCLE_NUMBER
	 */
	public java.lang.Integer getCycleNumber() {
		return cycleNumber;
	}

	/**
	 * Set the value related to the column: CYCLE_NUMBER
	 * @param cycleNumber the CYCLE_NUMBER value
	 */
	public void setCycleNumber(java.lang.Integer cycleNumber) {
		this.cycleNumber = cycleNumber;
	}

	/**
	 * Return the value associated with the column: STATUS
	 */
	public java.lang.String getStatus() {
		return status;
	}

	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
	public void setStatus(java.lang.String status) {
		this.status = status;
	}

	/**
	 * Return the value associated with the column: DAY_ONE_JSON
	 */
	public java.lang.String getDayOneJson() {
		return dayOneJson;
	}

	/**
	 * Set the value related to the column: DAY_ONE_JSON
	 * @param dayOneJson the DAY_ONE_JSON value
	 */
	public void setDayOneJson(java.lang.String dayOneJson) {
		this.dayOneJson = dayOneJson;
	}

	/**
	 * Return the value associated with the column: DAY_TWO_JSON
	 */
	public java.lang.String getDayTwoJson() {
		return dayTwoJson;
	}

	/**
	 * Set the value related to the column: DAY_TWO_JSON
	 * @param dayTwoJson the DAY_TWO_JSON value
	 */
	public void setDayTwoJson(java.lang.String dayTwoJson) {
		this.dayTwoJson = dayTwoJson;
	}

	/**
	 * Return the value associated with the column: DAY_THREE_JSON
	 */
	public java.lang.String getDayThreeJson() {
		return dayThreeJson;
	}

	/**
	 * Set the value related to the column: DAY_THREE_JSON
	 * @param dayThreeJson the DAY_THREE_JSON value
	 */
	public void setDayThreeJson(java.lang.String dayThreeJson) {
		this.dayThreeJson = dayThreeJson;
	}

	/**
	 * Return the value associated with the column: DAY_FOUR_JSON
	 */
	public java.lang.String getDayFourJson() {
		return dayFourJson;
	}

	/**
	 * Set the value related to the column: DAY_FOUR_JSON
	 * @param dayFourJson the DAY_FOUR_JSON value
	 */
	public void setDayFourJson(java.lang.String dayFourJson) {
		this.dayFourJson = dayFourJson;
	}

	/**
	 * Return the value associated with the column: DAY_FIVE_JSON
	 */
	public java.lang.String getDayFiveJson() {
		return dayFiveJson;
	}

	/**
	 * Set the value related to the column: DAY_FIVE_JSON
	 * @param dayFiveJson the DAY_FIVE_JSON value
	 */
	public void setDayFiveJson(java.lang.String dayFiveJson) {
		this.dayFiveJson = dayFiveJson;
	}

	/**
	 * Return the value associated with the column: DAY_SIX_JSON
	 */
	public java.lang.String getDaySixJson() {
		return daySixJson;
	}

	/**
	 * Set the value related to the column: DAY_SIX_JSON
	 * @param daySixJson the DAY_SIX_JSON value
	 */
	public void setDaySixJson(java.lang.String daySixJson) {
		this.daySixJson = daySixJson;
	}

	/**
	 * Return the value associated with the column: DAY_SEVEN_JSON
	 */
	public java.lang.String getDaySevenJson() {
		return daySevenJson;
	}

	/**
	 * Set the value related to the column: DAY_SEVEN_JSON
	 * @param daySevenJson the DAY_SEVEN_JSON value
	 */
	public void setDaySevenJson(java.lang.String daySevenJson) {
		this.daySevenJson = daySevenJson;
	}

	/**
	 * Return the value associated with the column: OUTLET_ID
	 */
	public java.lang.String getOutletId() {
		return outletId;
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
	public void setOutletId(java.lang.String outletId) {
		this.outletId = outletId;
	}

	/**
	 * Return the value associated with the column: CREATED_DATE
	 */
	public java.util.Date getCreatedDate() {
		return createdDate;
	}

	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
	public void setCreatedDate(java.util.Date createdDate) {
		this.createdDate = createdDate;
	}

	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */
	public java.util.Date getLastUpdateTime() {
		return lastUpdateTime;
	}

	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
	public void setLastUpdateTime(java.util.Date lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */
	public java.util.Date getLastSyncTime() {
		return lastSyncTime;
	}

	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
	public void setLastSyncTime(java.util.Date lastSyncTime) {
		this.lastSyncTime = lastSyncTime;
	}

	/**
	 * Return the value associated with the column: DELETED
	 */
	public java.lang.Boolean isDeleted() {
		return deleted == null ? Boolean.valueOf(false) : deleted;
	}

	public java.lang.Boolean getDeleted() {
		return deleted == null ? Boolean.valueOf(false) : deleted;
	}

	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
	public void setDeleted(java.lang.Boolean deleted) {
		this.deleted = deleted;
	}

	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue() {
		return "false";
	}

	/**
	 * Return the value associated with the column: PROPERTIES
	 */
	public java.lang.String getProperties() {
		return properties;
	}

	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
	public void setProperties(java.lang.String properties) {
		this.properties = properties;
	}

	/**
	 * Return the value associated with the column: PERFORMER_ID
	 */
	public java.lang.String getPerformerId() {
		return performerId;
	}

	/**
	 * Set the value related to the column: PERFORMER_ID
	 * @param performerId the PERFORMER_ID value
	 */
	public void setPerformerId(java.lang.String performerId) {
		this.performerId = performerId;
	}

	/**
	 * Return the value associated with the column: PERFORMER_NAME
	 */
	public java.lang.String getPerformerName() {
		return performerName;
	}

	/**
	 * Set the value related to the column: PERFORMER_NAME
	 * @param performerName the PERFORMER_NAME value
	 */
	public void setPerformerName(java.lang.String performerName) {
		this.performerName = performerName;
	}

	/**
	 * Return the value associated with the column: processNotes
	 */
	public java.util.List<com.floreantpos.model.ChemoProcessNote> getProcessNotes() {
		return processNotes;
	}

	/**
	 * Set the value related to the column: processNotes
	 * @param processNotes the processNotes value
	 */
	public void setProcessNotes(java.util.List<com.floreantpos.model.ChemoProcessNote> processNotes) {
		this.processNotes = processNotes;
	}

	public void addToProcessNotes(com.floreantpos.model.ChemoProcessNote chemoProcessNote) {
		if (null == getProcessNotes()) setProcessNotes(new java.util.ArrayList<com.floreantpos.model.ChemoProcessNote>());
		getProcessNotes().add(chemoProcessNote);
	}

	public boolean equals(Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.ChemoCycle)) return false;
		else {
			com.floreantpos.model.ChemoCycle chemoCycle = (com.floreantpos.model.ChemoCycle) obj;
			if (null == this.getId() || null == chemoCycle.getId()) return this == obj;
			else return (this.getId().equals(chemoCycle.getId()));
		}
	}

	public int hashCode() {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo(Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString() {
		return super.toString();
	}
}
