package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the DOCUMENT_META table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="DOCUMENT_META"
 */

public abstract class BaseDocumentMeta implements Comparable, Serializable {

	public static String REF = "DocumentMeta"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_PERFORMER_ID = "performerId"; //$NON-NLS-1$
	public static String PROP_PERFORMER_NAME = "performerName"; //$NON-NLS-1$
	public static String PROP_PERFORM_DATE = "performDate"; //$NON-NLS-1$
	public static String PROP_DOCUMENT_ID = "documentId"; //$NON-NLS-1$
	public static String PROP_R2_KEY = "r2Key"; //$NON-NLS-1$
	public static String PROP_FILE_NAME = "fileName"; //$NON-NLS-1$
	public static String PROP_MIME_TYPE = "mimeType"; //$NON-NLS-1$
	public static String PROP_FILE_SIZE = "fileSize"; //$NON-NLS-1$
	public static String PROP_DOCUMENT_TYPE_NAME = "documentTypeName"; //$NON-NLS-1$
	public static String PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static String PROP_FILE_PATH = "filePath"; //$NON-NLS-1$
	public static String PROP_ENTITY_MODEL = "entityModel"; //$NON-NLS-1$
	public static String PROP_ENTITY_ID = "entityId"; //$NON-NLS-1$
	public static String PROP_ENTITY_NAME = "entityName"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseDocumentMeta () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseDocumentMeta (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
	private java.util.Date lastUpdateTime;
	private java.util.Date lastSyncTime;
	private java.lang.String outletId;
	private java.lang.String properties;
	private java.lang.Boolean deleted;
	private java.lang.String performerId;
	private java.lang.String performerName;
	private java.util.Date performDate;
	private java.lang.String documentId;
	private java.lang.String r2Key;
	private java.lang.String fileName;
	private java.lang.String mimeType;
	private java.lang.Long fileSize;
	private java.lang.String documentTypeName;
	private java.lang.String description;
	private java.lang.String filePath;
	private java.lang.String entityModel;
	private java.lang.String entityId;
	private java.lang.String entityName;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.DateBasedIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */
	public java.util.Date getLastUpdateTime () {
		return lastUpdateTime;
	}

	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
	public void setLastUpdateTime (java.util.Date lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */
	public java.util.Date getLastSyncTime () {
		return lastSyncTime;
	}

	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
	public void setLastSyncTime (java.util.Date lastSyncTime) {
		this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */
	public java.lang.String getOutletId () {
		return outletId;
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
	public void setOutletId (java.lang.String outletId) {
		this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */
	public java.lang.String getProperties () {
		return properties;
	}

	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
	public void setProperties (java.lang.String properties) {
		this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */
	public java.lang.Boolean getDeleted () {
		return deleted;
	}

	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
	public void setDeleted (java.lang.Boolean deleted) {
		this.deleted = deleted;
	}



	/**
	 * Return the value associated with the column: PERFORMER_ID
	 */
	public java.lang.String getPerformerId () {
		return performerId;
	}

	/**
	 * Set the value related to the column: PERFORMER_ID
	 * @param performerId the PERFORMER_ID value
	 */
	public void setPerformerId (java.lang.String performerId) {
		this.performerId = performerId;
	}



	/**
	 * Return the value associated with the column: PERFORMER_NAME
	 */
	public java.lang.String getPerformerName () {
		return performerName;
	}

	/**
	 * Set the value related to the column: PERFORMER_NAME
	 * @param performerName the PERFORMER_NAME value
	 */
	public void setPerformerName (java.lang.String performerName) {
		this.performerName = performerName;
	}



	/**
	 * Return the value associated with the column: PERFORM_DATE
	 */
	public java.util.Date getPerformDate () {
		return performDate;
	}

	/**
	 * Set the value related to the column: PERFORM_DATE
	 * @param performDate the PERFORM_DATE value
	 */
	public void setPerformDate (java.util.Date performDate) {
		this.performDate = performDate;
	}



	/**
	 * Return the value associated with the column: DOCUMENT_ID
	 */
	public java.lang.String getDocumentId () {
		return documentId;
	}

	/**
	 * Set the value related to the column: DOCUMENT_ID
	 * @param documentId the DOCUMENT_ID value
	 */
	public void setDocumentId (java.lang.String documentId) {
		this.documentId = documentId;
	}



	/**
	 * Return the value associated with the column: R2_KEY
	 */
	public java.lang.String getR2Key () {
		return r2Key;
	}

	/**
	 * Set the value related to the column: R2_KEY
	 * @param r2Key the R2_KEY value
	 */
	public void setR2Key (java.lang.String r2Key) {
		this.r2Key = r2Key;
	}



	/**
	 * Return the value associated with the column: FILE_NAME
	 */
	public java.lang.String getFileName () {
		return fileName;
	}

	/**
	 * Set the value related to the column: FILE_NAME
	 * @param fileName the FILE_NAME value
	 */
	public void setFileName (java.lang.String fileName) {
		this.fileName = fileName;
	}



	/**
	 * Return the value associated with the column: MIME_TYPE
	 */
	public java.lang.String getMimeType () {
		return mimeType;
	}

	/**
	 * Set the value related to the column: MIME_TYPE
	 * @param mimeType the MIME_TYPE value
	 */
	public void setMimeType (java.lang.String mimeType) {
		this.mimeType = mimeType;
	}



	/**
	 * Return the value associated with the column: FILE_SIZE
	 */
	public java.lang.Long getFileSize () {
		return fileSize;
	}

	/**
	 * Set the value related to the column: FILE_SIZE
	 * @param fileSize the FILE_SIZE value
	 */
	public void setFileSize (java.lang.Long fileSize) {
		this.fileSize = fileSize;
	}



	/**
	 * Return the value associated with the column: DOCUMENT_TYPE_NAME
	 */
	public java.lang.String getDocumentTypeName () {
		return documentTypeName;
	}

	/**
	 * Set the value related to the column: DOCUMENT_TYPE_NAME
	 * @param documentTypeName the DOCUMENT_TYPE_NAME value
	 */
	public void setDocumentTypeName (java.lang.String documentTypeName) {
		this.documentTypeName = documentTypeName;
	}



	/**
	 * Return the value associated with the column: DESCRIPTION
	 */
	public java.lang.String getDescription () {
		return description;
	}

	/**
	 * Set the value related to the column: DESCRIPTION
	 * @param description the DESCRIPTION value
	 */
	public void setDescription (java.lang.String description) {
		this.description = description;
	}



	/**
	 * Return the value associated with the column: FILE_PATH
	 */
	public java.lang.String getFilePath () {
		return filePath;
	}

	/**
	 * Set the value related to the column: FILE_PATH
	 * @param filePath the FILE_PATH value
	 */
	public void setFilePath (java.lang.String filePath) {
		this.filePath = filePath;
	}



	/**
	 * Return the value associated with the column: ENTITY_MODEL
	 */
	public java.lang.String getEntityModel () {
		return entityModel;
	}

	/**
	 * Set the value related to the column: ENTITY_MODEL
	 * @param entityModel the ENTITY_MODEL value
	 */
	public void setEntityModel (java.lang.String entityModel) {
		this.entityModel = entityModel;
	}



	/**
	 * Return the value associated with the column: ENTITY_ID
	 */
	public java.lang.String getEntityId () {
		return entityId;
	}

	/**
	 * Set the value related to the column: ENTITY_ID
	 * @param entityId the ENTITY_ID value
	 */
	public void setEntityId (java.lang.String entityId) {
		this.entityId = entityId;
	}



	/**
	 * Return the value associated with the column: ENTITY_NAME
	 */
	public java.lang.String getEntityName () {
		return entityName;
	}

	/**
	 * Set the value related to the column: ENTITY_NAME
	 * @param entityName the ENTITY_NAME value
	 */
	public void setEntityName (java.lang.String entityName) {
		this.entityName = entityName;
	}


	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.DocumentMeta)) return false;
		else {
			com.floreantpos.model.DocumentMeta documentMeta = (com.floreantpos.model.DocumentMeta) obj;
			if (null == this.getId() || null == documentMeta.getId()) return false;
			else return (this.getId().equals(documentMeta.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}
