package com.orocube.medlogics.chemo;

import java.io.Serializable;

/**
 * Helper POJO for storing dynamic vital signs with name-value pairs
 * Used for flexible vital sign tracking in Chemotherapy
 */
public class ExtraVital implements Serializable {
	private static final long serialVersionUID = 1L;

	private String name;
	private String value;
	private String unit;

	public ExtraVital() {
	}

	public ExtraVital(String name, String value) {
		this.name = name;
		this.value = value;
	}

	public ExtraVital(String name, String value, String unit) {
		this.name = name;
		this.value = value;
		this.unit = unit;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getUnit() {
		return unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	@Override
	public String toString() {
		return "ExtraVital{" +
				"name='" + name + '\'' +
				", value='" + value + '\'' +
				", unit='" + unit + '\'' +
				'}';
	}
}
