package com.floreantpos.model.base;

import java.io.Serializable;

/**
 * This is an object that contains data related to the CHEMO_PROCESS_NOTE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="CHEMO_PROCESS_NOTE"
 */
public abstract class BaseChemoProcessNote implements Comparable, Serializable {

	public static String REF = "ChemoProcessNote"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_CHEMO_CYCLE = "chemoCycle"; //$NON-NLS-1$
	public static String PROP_PROCESS_DATE = "processDate"; //$NON-NLS-1$
	public static String PROP_BODY_WEIGHT = "bodyWeight"; //$NON-NLS-1$
	public static String PROP_NOTE_JSON = "noteJson"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_PERFORMER_ID = "performerId"; //$NON-NLS-1$
	public static String PROP_PERFORMER_NAME = "performerName"; //$NON-NLS-1$

	// constructors
	public BaseChemoProcessNote() {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseChemoProcessNote(java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize() {}

	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
	private java.util.Date processDate;
	private java.lang.Double bodyWeight;
	private java.lang.String noteJson;
	private java.lang.String outletId;
	private java.util.Date createdDate;
	private java.util.Date lastUpdateTime;
	private java.util.Date lastSyncTime;
	private java.lang.Boolean deleted;
	private java.lang.String properties;
	private java.lang.String performerId;
	private java.lang.String performerName;

	// many to one
	private com.floreantpos.model.ChemoCycle chemoCycle;

	/**
	 * Return the unique identifier of this class
	 * @hibernate.id
	 *  generator-class="com.floreantpos.util.UUIdGenerator"
	 *  column="ID"
	 */
	public java.lang.String getId() {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId(java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}

	/**
	 * Return the value associated with the column: CHEMO_CYCLE_ID
	 */
	public com.floreantpos.model.ChemoCycle getChemoCycle() {
		return chemoCycle;
	}

	/**
	 * Set the value related to the column: CHEMO_CYCLE_ID
	 * @param chemoCycle the CHEMO_CYCLE_ID value
	 */
	public void setChemoCycle(com.floreantpos.model.ChemoCycle chemoCycle) {
		this.chemoCycle = chemoCycle;
	}

	/**
	 * Return the value associated with the column: DATE
	 */
	public java.util.Date getProcessDate() {
		return processDate;
	}

	/**
	 * Set the value related to the column: DATE
	 * @param processDate the DATE value
	 */
	public void setProcessDate(java.util.Date processDate) {
		this.processDate = processDate;
	}

	/**
	 * Return the value associated with the column: BODY_WEIGHT
	 */
	public java.lang.Double getBodyWeight() {
		return bodyWeight;
	}

	/**
	 * Set the value related to the column: BODY_WEIGHT
	 * @param bodyWeight the BODY_WEIGHT value
	 */
	public void setBodyWeight(java.lang.Double bodyWeight) {
		this.bodyWeight = bodyWeight;
	}

	/**
	 * Return the value associated with the column: NOTE_JSON
	 */
	public java.lang.String getNoteJson() {
		return noteJson;
	}

	/**
	 * Set the value related to the column: NOTE_JSON
	 * @param noteJson the NOTE_JSON value
	 */
	public void setNoteJson(java.lang.String noteJson) {
		this.noteJson = noteJson;
	}

	/**
	 * Return the value associated with the column: OUTLET_ID
	 */
	public java.lang.String getOutletId() {
		return outletId;
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
	public void setOutletId(java.lang.String outletId) {
		this.outletId = outletId;
	}

	/**
	 * Return the value associated with the column: CREATED_DATE
	 */
	public java.util.Date getCreatedDate() {
		return createdDate;
	}

	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
	public void setCreatedDate(java.util.Date createdDate) {
		this.createdDate = createdDate;
	}

	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */
	public java.util.Date getLastUpdateTime() {
		return lastUpdateTime;
	}

	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
	public void setLastUpdateTime(java.util.Date lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */
	public java.util.Date getLastSyncTime() {
		return lastSyncTime;
	}

	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
	public void setLastSyncTime(java.util.Date lastSyncTime) {
		this.lastSyncTime = lastSyncTime;
	}

	/**
	 * Return the value associated with the column: DELETED
	 */
	public java.lang.Boolean isDeleted() {
		return deleted == null ? Boolean.valueOf(false) : deleted;
	}

	public java.lang.Boolean getDeleted() {
		return deleted == null ? Boolean.valueOf(false) : deleted;
	}

	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
	public void setDeleted(java.lang.Boolean deleted) {
		this.deleted = deleted;
	}

	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue() {
		return "false";
	}

	/**
	 * Return the value associated with the column: PROPERTIES
	 */
	public java.lang.String getProperties() {
		return properties;
	}

	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
	public void setProperties(java.lang.String properties) {
		this.properties = properties;
	}

	/**
	 * Return the value associated with the column: PERFORMER_ID
	 */
	public java.lang.String getPerformerId() {
		return performerId;
	}

	/**
	 * Set the value related to the column: PERFORMER_ID
	 * @param performerId the PERFORMER_ID value
	 */
	public void setPerformerId(java.lang.String performerId) {
		this.performerId = performerId;
	}

	/**
	 * Return the value associated with the column: PERFORMER_NAME
	 */
	public java.lang.String getPerformerName() {
		return performerName;
	}

	/**
	 * Set the value related to the column: PERFORMER_NAME
	 * @param performerName the PERFORMER_NAME value
	 */
	public void setPerformerName(java.lang.String performerName) {
		this.performerName = performerName;
	}

	public boolean equals(Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.ChemoProcessNote)) return false;
		else {
			com.floreantpos.model.ChemoProcessNote chemoProcessNote = (com.floreantpos.model.ChemoProcessNote) obj;
			if (null == this.getId() || null == chemoProcessNote.getId()) return this == obj;
			else return (this.getId().equals(chemoProcessNote.getId()));
		}
	}

	public int hashCode() {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo(Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString() {
		return super.toString();
	}
}
