package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.ComboGroup;

public class ComboGroupDAO extends BaseComboGroupDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public ComboGroupDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public List<ComboGroup> getByMenuItemId(String menuItemId, Session session) {
		if (StringUtils.isEmpty(menuItemId)) {
			return new ArrayList<>(0);
		}
		Criteria criteria = session.createCriteria(ComboGroup.class);
		criteria.createAlias("items", "item");//$NON-NLS-1$//$NON-NLS-2$
		criteria.add(Restrictions.in("item.id", Arrays.asList(new String[] { menuItemId })));//$NON-NLS-1$
		return criteria.list();
	}

}