package com.floreantpos.model.dao;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosException;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.StoreBalance;

public class StoreBalanceDAO extends BaseStoreBalanceDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public StoreBalanceDAO() {
	}

	public StoreBalance getStoreBalance(String outletId, Session session) {
		if (StringUtils.isBlank(outletId)) {
			return null;
		}
		Criteria criteria = session.createCriteria(StoreBalance.class);
		criteria.add(Restrictions.eq(StoreBalance.PROP_OUTLET_ID, outletId));
		criteria.setMaxResults(1);
		return (StoreBalance) criteria.uniqueResult();
	}

	public double getOutletCashBalance(Outlet outlet) {
		try (Session session = createNewSession()) {
			return getOutletCashBalance(outlet, session);
		}
	}

	public double getOutletCashBalance(Outlet outlet, Session session) {
		Criteria criteria = session.createCriteria(StoreBalance.class);
		criteria.add(Restrictions.eq(StoreBalance.PROP_OUTLET_ID, outlet.getId()));
		criteria.setProjection(Projections.property(StoreBalance.PROP_CASH_BALANCE));

		Object result = criteria.uniqueResult();
		if (result instanceof Number) {
			return (double) result;
		}
		return 0.0;
	}

	public void updateOutletCashBalance(Outlet outlet, double outletCashBalance) {
		try (Session session = createNewSession()) {
			Transaction tx = session.beginTransaction();

			updateOutletCashBalance(session, outlet, outletCashBalance);

			tx.commit();
		}
	}

	public void updateOutletCashBalance(Session session, Outlet outlet, double outletCashBalance) {
		if (outlet == null) {
			throw new PosException("Outlet is required.");
		}
		Criteria criteria = session.createCriteria(StoreBalance.class);
		criteria.add(Restrictions.eq(StoreBalance.PROP_OUTLET_ID, outlet.getId()));
		criteria.setMaxResults(1);

		StoreBalance storeBalance = (StoreBalance) criteria.uniqueResult();
		if (storeBalance == null) {
			storeBalance = new StoreBalance();
			storeBalance.setCreateDate(StoreDAO.getServerTimestamp());
			storeBalance.setOutletId(outlet.getId());
		}
		storeBalance.setCashBalance(outletCashBalance);

		session.saveOrUpdate(storeBalance);
	}
}