package com.orocube.cloudflare.r2;

import com.floreantpos.PosException;

/**
 * Custom exception for Cloudflare R2 storage operations.
 * Extends PosException to integrate with existing exception handling.
 */
public class R2StorageException extends PosException {

	private static final long serialVersionUID = 1L;

	/**
	 * Constructs a new R2StorageException with the specified detail message.
	 *
	 * @param message the detail message
	 */
	public R2StorageException(String message) {
		super(message);
	}

	/**
	 * Constructs a new R2StorageException with the specified detail message and cause.
	 *
	 * @param message the detail message
	 * @param cause the cause of the exception
	 */
	public R2StorageException(String message, Throwable cause) {
		super(message, cause);
	}
}
