/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;

import com.floreantpos.PosLog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Pagination;

public class UpdateDBTo471 {

	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo471(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void updatePatientGender() {
		PosLog.info(getClass(), "Updating " + schemaName + " schema."); //$NON-NLS-1$ //$NON-NLS-2$

		int totalCustomers = rowCount();
		PosLog.info(UpdateDBTo471.class, "Found total customers: " + totalCustomers); //$NON-NLS-1$

		int increment = 100;
		int count = 0;
		while (count < totalCustomers) {
			try (Session session = sessionFactory.openSession()) {
				Transaction transaction = session.beginTransaction();

				Pagination<Customer> pagination = new Pagination<Customer>(count, increment);
				pagination.setNumRows(totalCustomers);
				findCustomers(pagination, session);

				List<Customer> customers = pagination.getDataList();
				for (Customer customer : customers) {
					String patientGender = customer.getProperty("patient.gender", "");
					if (StringUtils.isNotBlank(patientGender)) {
						customer.setGender(patientGender);
					}
				}
				transaction.commit();

				count += increment;
			}
		}

		PosLog.info(getClass(), schemaName + " update completed successfully"); //$NON-NLS-1$
	}

	private void findCustomers(Pagination<Customer> pagination, Session session) {
		Criteria criteria = createCustomersCriteria(session);
		criteria.addOrder(Order.asc(Customer.PROP_CREATE_DATE));
		criteria.setFirstResult(pagination.getCurrentRowIndex());
		criteria.setMaxResults(pagination.getPageSize());

		PosLog.info(getClass(),
				String.format("Searching from: %s to %s", pagination.getCurrentRowIndex(), (pagination.getCurrentRowIndex() + pagination.getPageSize()))); //$NON-NLS-1$

		pagination.setRows(criteria.list());

	}

	public int rowCount() {
		try (Session session = sessionFactory.openSession()) {
			Criteria criteria = createCustomersCriteria(session);
			criteria.setProjection(Projections.rowCount());
			return ((Long) criteria.uniqueResult()).intValue();
		}
	}

	private Criteria createCustomersCriteria(Session session) {
		Criteria criteria = session.createCriteria(Customer.class);
		return criteria;
	}

}
