package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum Gender {

	//@formatter:off
	Male("Male"), //$NON-NLS-1$
	Female("Female"), //$NON-NLS-1$
	Other("Other") //$NON-NLS-1$
	;
	//@formatter:on

	private final String displayName;

	public String getFoldType() {
		return displayName;
	}

	private Gender(String displayName) {
		this.displayName = displayName;
	}

	public static Gender fromString(String name) {
		if (StringUtils.isEmpty(name)) {
			return Male;
		}

		Gender[] values = values();
		for (Gender gender : values) {
			if (name.equals(gender.name())) {
				return gender;
			}
		}

		return Male;
	}

	@Override
	public String toString() {
		return displayName;
	}

}
