package com.floreantpos.model.base;

import java.io.Serializable;


/**
 * This is an object that contains data related to the CONSENTS table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="CONSENTS"
 */

public abstract class BaseConsent implements Comparable, Serializable {

	public static String REF = "Consents"; //$NON-NLS-1$
	public static String PROP_DOCTOR_ID = "doctorId"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_CONSENT_TYPE = "consentType"; //$NON-NLS-1$
	public static String PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_CONSENT_NAME = "consentName"; //$NON-NLS-1$
	public static String PROP_PATIENT_ID = "patientId"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_CREATE_DATE = "createDate"; //$NON-NLS-1$


	// constructors
	public BaseConsent () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseConsent (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date createDate;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String outletId;
				private java.lang.String patientId;
				private java.lang.String doctorId;
				private java.lang.String consentType;
				private java.lang.String consentName;
				private java.lang.String description;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: CREATE_DATE
	 */

	public java.util.Date getCreateDate () {
			return createDate;
	}



	/**
	 * Set the value related to the column: CREATE_DATE
	 * @param createDate the CREATE_DATE value
	 */
			public void setCreateDate (java.util.Date createDate) {
			this.createDate = createDate;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: PATIENT_ID
	 */

	public java.lang.String getPatientId () {
			return patientId;
	}



	/**
	 * Set the value related to the column: PATIENT_ID
	 * @param patientId the PATIENT_ID value
	 */
			public void setPatientId (java.lang.String patientId) {
			this.patientId = patientId;
	}



	/**
	 * Return the value associated with the column: DOCTOR_ID
	 */

	public java.lang.String getDoctorId () {
			return doctorId;
	}



	/**
	 * Set the value related to the column: DOCTOR_ID
	 * @param doctorId the DOCTOR_ID value
	 */
			public void setDoctorId (java.lang.String doctorId) {
			this.doctorId = doctorId;
	}



	/**
	 * Return the value associated with the column: CONSENT_TYPE
	 */

	public java.lang.String getConsentType () {
			return consentType;
	}



	/**
	 * Set the value related to the column: CONSENT_TYPE
	 * @param consentType the CONSENT_TYPE value
	 */
			public void setConsentType (java.lang.String consentType) {
			this.consentType = consentType;
	}



	/**
	 * Return the value associated with the column: CONSENT_NAME
	 */

	public java.lang.String getConsentName () {
			return consentName;
	}



	/**
	 * Set the value related to the column: CONSENT_NAME
	 * @param consentName the CONSENT_NAME value
	 */
			public void setConsentName (java.lang.String consentName) {
			this.consentName = consentName;
	}



	/**
	 * Return the value associated with the column: DESCRIPTION
	 */

	public java.lang.String getDescription () {
			return description;
	}



	/**
	 * Set the value related to the column: DESCRIPTION
	 * @param description the DESCRIPTION value
	 */
			public void setDescription (java.lang.String description) {
			this.description = description;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Consent)) return false;
		else {
			com.floreantpos.model.Consent consents = (com.floreantpos.model.Consent) obj;
			if (null == this.getId() || null == consents.getId()) return this == obj;
			else return (this.getId().equals(consents.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}