package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.User;
import com.orocube.rest.service.server.BaseDataServiceDao;

public class DeclaredTipsDAO extends BaseDeclaredTipsDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public DeclaredTipsDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public List<DeclaredTips> findBy(StoreSession currentData, User user) {
		Session session = null;
		try {
			session = getSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(DeclaredTips.PROP_SESSION_ID, currentData.getId()));
			criteria.add(Restrictions.eq(DeclaredTips.PROP_OWNER_ID, user.getId()));
			List list = criteria.list();
			return list;
		} finally {
			closeSession(session);
		}
	}

	public double findTotalAmount(Date fromDate, Date toDate, User user) {
		Session session = null;
		try {
			session = createNewSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.between(DeclaredTips.PROP_DECLARED_TIME, fromDate, toDate));
			criteria.add(Restrictions.eq(DeclaredTips.PROP_OWNER_ID, user.getId()));

			ProjectionList projectionList = Projections.projectionList();
			projectionList.add(Projections.sum(DeclaredTips.PROP_AMOUNT), DeclaredTips.PROP_AMOUNT);

			criteria.setProjection(projectionList);
			Number totalAmount = (Number) criteria.uniqueResult();
			if (totalAmount != null) {
				return totalAmount.doubleValue();

			}
		} finally {
			closeSession(session);
		}
		return 0.0;
	}

	public void saveOrUpdateDeclaredTipsList(List<DeclaredTips> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
		if (dataList == null)
			return;

		Transaction tx = null;
		Session session = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();

			for (Iterator<DeclaredTips> iterator = dataList.iterator(); iterator.hasNext();) {
				DeclaredTips item = (DeclaredTips) iterator.next();
				DeclaredTips existingItem = get(item.getId());
				if (existingItem != null) {
					if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
						PosLog.info(getClass(), item.getId() + " already updated"); //$NON-NLS-1$
						continue;
					}
					long version = existingItem.getVersion();
					PropertyUtils.copyProperties(existingItem, item);
					existingItem.setVersion(version);
					existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
					existingItem.setUpdateSyncTime(updateSyncTime);
					update(existingItem, session);
				}
				else {
					item.setUpdateLastUpdateTime(updateLastUpdateTime);
					item.setUpdateSyncTime(updateSyncTime);
					save(item, session);
				}
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		} finally {
			closeSession(session);
		}

	}

}