package com.floreantpos.report.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.ChartOfAccounts;
import com.floreantpos.model.util.DataProvider;

public class BalanceSheetLedgerEntryModel {

	private String id;
	private String coaId;
	private String coaTypeId;
	private String name;
	private double amount;
	private Integer direction;

	private double creditAmount;
	private double debitAmount;

	private String groupName;

	public String getCoaId() {
		return coaId;
	}

	public void setCoaId(String coaId) {
		this.coaId = coaId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCoaName() {
		if (StringUtils.isNotBlank(getName())) {
			return getName();
		}

		ChartOfAccounts chartOfAccounts = (ChartOfAccounts) DataProvider.get().getObjectOf(ChartOfAccounts.class, coaId);
		return chartOfAccounts != null ? chartOfAccounts.getName() : ""; //$NON-NLS-1$
	}

	public String getCoaAccountTypeId() {
		if (StringUtils.isNotBlank(coaTypeId)) {
			return coaTypeId;
		}
		if (coaId == null) {
			return "";
		}
		ChartOfAccounts chartOfAccounts = (ChartOfAccounts) DataProvider.get().getObjectOf(ChartOfAccounts.class, coaId);
		String coaAccountTypeId = chartOfAccounts.getCoaAccountTypeId();
		return coaAccountTypeId;
	}

	public void setCoaTypeId(String coaTypeId) {
		this.coaTypeId = coaTypeId;
	}

	public double getAmount() {
		return amount;
	}

	public void setAmount(double amount) {
		this.amount = amount;
	}

	public Integer getDirection() {
		return direction;
	}

	public void setDirection(Integer direction) {
		this.direction = direction;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public double getCreditAmount() {
		return creditAmount;
	}

	public void setCreditAmount(double creditAmount) {
		this.creditAmount = creditAmount;
	}

	public double getDebitAmount() {
		return debitAmount;
	}

	public void setDebitAmount(double debitAmount) {
		this.debitAmount = debitAmount;
	}

	public double getBalanceAmount() {
		return debitAmount - creditAmount;
	}

	public String getGroupName() {
		if (StringUtils.isBlank(groupName)) {
			return "";
		}
		
		return groupName;
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	@Override
	public String toString() {
		return getName();
	}

}