package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the EMPLOYEE_IN_OUT_HISTORY table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="EMPLOYEE_IN_OUT_HISTORY"
 */

public abstract class BaseEmployeeInOutHistory  implements Comparable, Serializable {

	public static String REF = "EmployeeInOutHistory"; //$NON-NLS-1$
	public static String PROP_SHIFT = "shift"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_USER = "user"; //$NON-NLS-1$
	public static String PROP_OUT_TIME = "outTime"; //$NON-NLS-1$
	public static String PROP_OUT_HOUR = "outHour"; //$NON-NLS-1$
	public static String PROP_IN_HOUR = "inHour"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_TERMINAL = "terminal"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_IN_TIME = "inTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_CLOCK_OUT = "clockOut"; //$NON-NLS-1$


	// constructors
	public BaseEmployeeInOutHistory () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseEmployeeInOutHistory (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date outTime;
				private java.util.Date inTime;
				private java.lang.Short outHour;
				private java.lang.Short inHour;
				private java.lang.Boolean clockOut;
				private java.lang.String outletId;
				private java.lang.String properties;
	
	// many to one
	private com.floreantpos.model.User user;
	private com.floreantpos.model.Shift shift;
	private com.floreantpos.model.Terminal terminal;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: OUT_TIME
	 */

	public java.util.Date getOutTime () {
			return outTime;
	}



	/**
	 * Set the value related to the column: OUT_TIME
	 * @param outTime the OUT_TIME value
	 */
			public void setOutTime (java.util.Date outTime) {
			this.outTime = outTime;
	}



	/**
	 * Return the value associated with the column: IN_TIME
	 */

	public java.util.Date getInTime () {
			return inTime;
	}



	/**
	 * Set the value related to the column: IN_TIME
	 * @param inTime the IN_TIME value
	 */
			public void setInTime (java.util.Date inTime) {
			this.inTime = inTime;
	}



	/**
	 * Return the value associated with the column: OUT_HOUR
	 */

	public java.lang.Short getOutHour () {
			return outHour;
	}



	/**
	 * Set the value related to the column: OUT_HOUR
	 * @param outHour the OUT_HOUR value
	 */
			public void setOutHour (java.lang.Short outHour) {
			this.outHour = outHour;
	}



	/**
	 * Return the value associated with the column: IN_HOUR
	 */

	public java.lang.Short getInHour () {
			return inHour;
	}



	/**
	 * Set the value related to the column: IN_HOUR
	 * @param inHour the IN_HOUR value
	 */
			public void setInHour (java.lang.Short inHour) {
			this.inHour = inHour;
	}



	/**
	 * Return the value associated with the column: CLOCK_OUT
	 */

	public java.lang.Boolean isClockOut () {
					return clockOut == null ? Boolean.FALSE : clockOut;
		}

	public java.lang.Boolean getClockOut () {
				return clockOut == null ? Boolean.FALSE : clockOut;
			}


	/**
	 * Set the value related to the column: CLOCK_OUT
	 * @param clockOut the CLOCK_OUT value
	 */
			public void setClockOut (java.lang.Boolean clockOut) {
			this.clockOut = clockOut;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: USER_OUTLET_ID
	 */

	public com.floreantpos.model.User getUser () {
			return user;
	}



	/**
	 * Set the value related to the column: USER_OUTLET_ID
	 * @param user the USER_OUTLET_ID value
	 */
			public void setUser (com.floreantpos.model.User user) {
			this.user = user;
	}



	/**
	 * Return the value associated with the column: SHIFT_ID
	 */

	public com.floreantpos.model.Shift getShift () {
			return shift;
	}



	/**
	 * Set the value related to the column: SHIFT_ID
	 * @param shift the SHIFT_ID value
	 */
			public void setShift (com.floreantpos.model.Shift shift) {
			this.shift = shift;
	}



	/**
	 * Return the value associated with the column: TERMINAL_ID
	 */

	public com.floreantpos.model.Terminal getTerminal () {
			return terminal;
	}



	/**
	 * Set the value related to the column: TERMINAL_ID
	 * @param terminal the TERMINAL_ID value
	 */
			public void setTerminal (com.floreantpos.model.Terminal terminal) {
			this.terminal = terminal;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.EmployeeInOutHistory)) return false;
		else {
			com.floreantpos.model.EmployeeInOutHistory employeeInOutHistory = (com.floreantpos.model.EmployeeInOutHistory) obj;
			if (null == this.getId() || null == employeeInOutHistory.getId()) return this == obj;
			else return (this.getId().equals(employeeInOutHistory.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}