/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.swing.table.AbstractTableModel;

import org.apache.commons.collections.map.HashedMap;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.print.PosPrintService;

public class StoreSessionReportModel extends AbstractTableModel {

	private final static SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yy hh:mm a"); //$NON-NLS-1$
	private String[] columnNames = { "openTime", "closeTime", "openedBy", "closedBy", "totalAmount", "salesTax", "totalRevenues", "creditCardReceipt", //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
			"grossReceipt", "cashAccountable" }; //$NON-NLS-1$ //$NON-NLS-2$
	private List<StoreSession> items;
	private Map<String, CashDrawer> reportMap = new HashedMap();

	public StoreSessionReportModel() {
		super();
	}

	public int getRowCount() {
		if (items == null)
			return 0;

		return items.size();
	}

	public int getColumnCount() {
		return columnNames.length;
	}

	@Override
	public String getColumnName(int column) {
		return columnNames[column];
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		StoreSession item = items.get(rowIndex);
		CashDrawer summary = reportMap.get(item.getId());

		switch (columnIndex) {
			case 0:
				Date openTime = item.getOpenTime();
				if (openTime == null)
					return ""; //$NON-NLS-1$
				return dateFormat.format(openTime);

			case 1:
				Date closeTime = item.getCloseTime();
				if (closeTime == null)
					return ""; //$NON-NLS-1$
				return dateFormat.format(closeTime);

			case 2:
				User openedBy = item.getOpenedBy();
				if (openedBy == null)
					return ""; //$NON-NLS-1$
				return openedBy.getFirstName();

			case 3:
				User closedBy = item.getClosedBy();
				if (closedBy == null)
					return ""; //$NON-NLS-1$
				return closedBy.getFirstName();

			case 4:
				return summary.getNetSales();

			case 5:
				return summary.getSalesTax();
			case 6:
				return summary.getTotalRevenue();
			case 7:
				return summary.getCreditCardReceiptAmount();
			case 8:
				return summary.getGrossReceipts();
			case 9:
				return summary.getDrawerAccountable();
		}
		return null;
	}

	public List<StoreSession> getItems() {
		return items;
	}

	public void setItems(List<StoreSession> items) {
		this.items = items;
		if (items != null) {
			for (StoreSession storeSession : items) {
				List<CashDrawer> cashDrawers = CashDrawerDAO.getInstance().findByStoreOperationData(storeSession, null);
				if (cashDrawers != null) {
					CashDrawer report = PosPrintService.populateCashDrawerReportSummary(cashDrawers);
					reportMap.put(storeSession.getId(), report);
				}
			}
		}
	}
}
