package com.orocube.medlogics.chemo;

/**
 * Status enum for ChemoCycle
 */
public enum ChemoCycleStatus {
	SCHEDULED("Scheduled", 0), IN_PROGRESS("In Progress", 1), COMPLETED("Completed", 2), DELAYED("Delayed", 3), SKIPPED("Skipped", 4);

	private final String displayString;
	private final int index;

	ChemoCycleStatus(String displayString, int index) {
		this.displayString = displayString;
		this.index = index;
	}

	public String getDisplayString() {
		return displayString;
	}

	public int getIndex() {
		return index;
	}

	@Override
	public String toString() {
		return displayString;
	}

	public static ChemoCycleStatus fromString(String status) {
		if (status == null) {
			return null;
		}
		for (ChemoCycleStatus s : ChemoCycleStatus.values()) {
			if (s.name().equalsIgnoreCase(status) || s.displayString.equalsIgnoreCase(status)) {
				return s;
			}
		}
		return null;
	}
}
